# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytest_fastapi_deps']

package_data = \
{'': ['*']}

install_requires = \
['click<8.1', 'fastapi', 'pytest']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=4.5.0,<5.0.0']}

entry_points = \
{'pytest11': ['pytest_fastapi_deps = pytest_fastapi_deps']}

setup_kwargs = {
    'name': 'pytest-fastapi-deps',
    'version': '0.2.0',
    'description': 'A fixture which allows easy replacement of fastapi dependencies for testing',
    'long_description': '# pytest-fastapi-deps\n\n<div align="center">\n\n[![Build status](https://github.com/pksol/pytest-fastapi-deps/workflows/build/badge.svg?branch=master&event=push)](https://github.com/pksol/pytest-fastapi-deps/actions?query=workflow%3Abuild)\n[![Python Version](https://img.shields.io/pypi/pyversions/pytest-fastapi-deps.svg)](https://pypi.org/project/pytest-fastapi-deps/)\n[![Dependencies Status](https://img.shields.io/badge/dependencies-up%20to%20date-brightgreen.svg)](https://github.com/pksol/pytest-fastapi-deps/pulls?utf8=%E2%9C%93&q=is%3Apr%20author%3Aapp%2Fdependabot)\n\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Security: bandit](https://img.shields.io/badge/security-bandit-green.svg)](https://github.com/PyCQA/bandit)\n[![Pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pksol/pytest-fastapi-deps/blob/master/.pre-commit-config.yaml)\n[![Semantic Versions](https://img.shields.io/badge/%20%20%F0%9F%93%A6%F0%9F%9A%80-semantic--versions-e10079.svg)](https://github.com/pksol/pytest-fastapi-deps/releases)\n[![License](https://img.shields.io/github/license/pksol/pytest-fastapi-deps)](https://github.com/pksol/pytest-fastapi-deps/blob/master/LICENSE)\n\nA fixture which allows easy replacement of fastapi dependencies for testing\n\n</div>\n\n## Installation\n\n```bash\npip install pytest-fastapi-deps\n```\n\nor install with `Poetry`\n\n```bash\npoetry add pytest-fastapi-deps\n```\n\n## Use case\nSuppose that you have this fastapi endpoint which has a couple of dependencies:\n```python\nfrom fastapi import Depends, FastAPI\n\napp = FastAPI()\n\n\nasync def first_dep():\n    return {"skip": 0, "limit": 100}\n\n\ndef second_dep():\n    return {"skip": 20, "limit": 50}\n\n\n@app.get("/depends/")\nasync def get_depends(\n    first_dep: dict = Depends(first_dep), second_dep: dict = Depends(second_dep)\n):\n    return {"first_dep": first_dep, "second_dep": second_dep}\n```\n\nFor simplicity, this example holds static dictionaries, but in reality these \ndependencies can be anything: dynamic configuration, database information, the \ncurrent user\'s information, etc.\n\nIf you want to test your fastapi endpoint you might wish to mock or replace these \ndependencies with your test code.\n\nThis is where the `fastapi_dep` fixture comes to play.\n\n## Usage\nThe most basic usage is to replace a dependency with a context manager:\n\n```python\nfrom my_project.main import app, first_dep, second_dep\nfrom fastapi.testclient import TestClient\n\nclient = TestClient(app)\n\ndef my_second_override():\n    return {"another": "override"}\n\n\ndef test_get_override_two_dep(fastapi_dep):\n    with fastapi_dep(app).override(\n        {\n            first_dep: "plain_override_object",\n            second_dep: my_second_override,\n        }\n    ):\n        response = client.get("/depends")\n        assert response.status_code == 200\n        assert response.json() == {\n            "first_dep": "plain_override_object",\n            "second_dep": {"another": "override"},\n        }\n```\n\nNote how easy it is: you add the `fastapi_dep` fixture, initialize it with the fastapi\n`app` and send a dictionary of overrides: the keys are the original functions while the \nvalues are plain objects that would be returned or replacement functions that would be \ncalled.\n\nIf your use case is to replace the dependencies for the entire duration of your test,\nyou can use pytest [indirect parameters](https://docs.pytest.org/en/latest/example/parametrize.html#indirect-parametrization) to simplify the body of your test:\n\n```python\nimport pytest\n\nfrom my_project.main import app, first_dep, second_dep\nfrom fastapi.testclient import TestClient\n\nclient = TestClient(app)\n\n@pytest.mark.parametrize(\n    "fastapi_dep",\n    [\n        (\n            app,\n            {first_dep: lambda: {"my": "override"}},\n        )\n    ],\n    indirect=True,\n)\ndef test_get_override_indirect_dep_param(fastapi_dep):\n    response = client.get("/depends")\n    assert response.status_code == 200\n    assert response.json() == {\n        "first_dep": {"my": "override"},\n        "second_dep": {"skip": 20, "limit": 50},\n    }\n```\nYou must use `indirect=True` and pass a tuple where the first item is the `app` and the\nsecond item is the dictionary with replacement functions.\n\nYou can do more fancy stuff and utilize the nature of nested python context managers:\n\n```python\nfrom my_project.main import app, first_dep, second_dep\nfrom fastapi.testclient import TestClient\n\nclient = TestClient(app)\n\n\ndef test_get_override_dep_inner_context(fastapi_dep):\n    with fastapi_dep(app).override({first_dep: lambda: {"my": "override"}}):\n        response = client.get("/depends")\n        assert response.status_code == 200\n        assert response.json() == {\n            "first_dep": {"my": "override"},  # overridden \n            "second_dep": {"skip": 20, "limit": 50},  # stayed the same\n        }\n\n        # add another override\n        with fastapi_dep(app).override({second_dep: lambda: {"another": "override"}}):\n            response = client.get("/depends")\n            assert response.status_code == 200\n            assert response.json() == {\n                "first_dep": {"my": "override"},  # overridden \n                "second_dep": {"another": "override"},  # overridden \n            }\n\n        # second override is gone - expect that only the first is overridden\n        response = client.get("/depends")\n        assert response.status_code == 200\n        assert response.json() == {\n            "first_dep": {"my": "override"},  # overridden \n            "second_dep": {"skip": 20, "limit": 50},  # returned to normal behaviour \n        }\n\n    # back to normal behaviour\n    response = client.get("/depends")\n    assert response.status_code == 200\n    assert response.json() == {\n        "first_dep": {"skip": 0, "limit": 100},\n        "second_dep": {"skip": 20, "limit": 50},\n    }\n```\n\n## 📈 Releases\n\nYou can see the list of available releases on the [GitHub Releases](https://github.com/pksol/pytest-fastapi-deps/releases) page.\n\nWe follow [Semantic Versions](https://semver.org/) specification.\n\n## 🛡 License\n\n[![License](https://img.shields.io/github/license/pksol/pytest-fastapi-deps)](https://github.com/pksol/pytest-fastapi-deps/blob/master/LICENSE)\n\nThis project is licensed under the terms of the `MIT` license. See [LICENSE](https://github.com/pksol/pytest-fastapi-deps/blob/master/LICENSE) for more details.\n\n## 📃 Citation\n\n```bibtex\n@misc{pytest-fastapi-deps,\n  author = {Peter Kogan},\n  title = {A fixture which allows easy replacement of fastapi dependencies for testing},\n  year = {2022},\n  publisher = {GitHub},\n  journal = {GitHub repository},\n  howpublished = {\\url{https://github.com/pksol/pytest-fastapi-deps}}\n}\n```\n\n## Credits [![🚀 Your next Python package needs a bleeding-edge project structure.](https://img.shields.io/badge/python--package--template-%F0%9F%9A%80-brightgreen)](https://github.com/TezRomacH/python-package-template)\n\nThis project was generated with [`python-package-template`](https://github.com/TezRomacH/python-package-template)\n',
    'author': 'Peter Kogan',
    'author_email': 'kogan.peter@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pksol/pytest-fastapi-deps',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
