# Generated by Django 3.2.5 on 2021-07-26 08:02

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_qiyu_token.models.jwt_app


class Migration(migrations.Migration):

    dependencies = [
        ("django_qiyu_token", "0002_alter_bearertokenmodel_user"),
    ]

    operations = [
        migrations.CreateModel(
            name="JwtAppModel",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "app_name",
                    models.CharField(
                        help_text="方便人类记忆的名称",
                        max_length=255,
                        unique=True,
                        verbose_name="密钥名称",
                    ),
                ),
                (
                    "app_type",
                    models.CharField(
                        default="HS256",
                        help_text="密钥的类型",
                        max_length=32,
                        verbose_name="JWT类型",
                    ),
                ),
                (
                    "app_key",
                    models.TextField(
                        default=django_qiyu_token.models.jwt_app.gen_key,
                        editable=False,
                        help_text="JWT 加密/解密 使用的密钥",
                        unique=True,
                        verbose_name="密钥",
                    ),
                ),
                (
                    "jwt_iss",
                    models.CharField(
                        help_text="JSON Web Token iss 字段值",
                        max_length=255,
                        verbose_name="JWT ISS",
                    ),
                ),
                (
                    "ctime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        help_text="这个密钥的创建时间",
                        verbose_name="创建时间",
                    ),
                ),
            ],
            options={
                "verbose_name": "JWT应用",
                "verbose_name_plural": "JWT应用",
            },
        ),
        migrations.CreateModel(
            name="JwtTokenModel",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "jwt_sub",
                    models.CharField(
                        help_text="JSON web token sub 用户字段的值",
                        max_length=255,
                        verbose_name="JWT sub",
                    ),
                ),
                (
                    "jwt_aud",
                    models.CharField(
                        help_text="JSON web token aud 目标用户字段",
                        max_length=255,
                        verbose_name="JWT aud",
                    ),
                ),
                (
                    "jwt_exp",
                    models.DateTimeField(
                        help_text="JSON web token exp 过期时间字段", verbose_name="JWT exp"
                    ),
                ),
                (
                    "jwt_nbf",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="JSON web token nbf 不早于时间时间字段",
                        verbose_name="JWT nbf",
                    ),
                ),
                (
                    "jwt_app",
                    models.ForeignKey(
                        help_text="JSON web token 应用",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="django_qiyu_token.jwtappmodel",
                        verbose_name="JWT应用",
                    ),
                ),
            ],
            options={
                "verbose_name": "JWT令牌",
                "verbose_name_plural": "JWT令牌",
            },
        ),
    ]
