"""Initial migration

Revision ID: 274bc650f9a2
Revises:
Create Date: 2022-03-17 14:41:26.913781

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "274bc650f9a2"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "admin_session_tokens",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("token", sa.String(length=255), nullable=False),
        sa.Column("raw_tokens", sa.Text(), nullable=False),
        sa.Column("raw_userinfo", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("token"),
    )
    op.create_index(
        op.f("ix_admin_session_tokens_created_at"),
        "admin_session_tokens",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_admin_session_tokens_updated_at"),
        "admin_session_tokens",
        ["updated_at"],
        unique=False,
    )
    op.create_table(
        "workspaces",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("domain", sa.String(length=255), nullable=False),
        sa.Column(
            "database_type",
            sa.Enum("POSTGRESQL", "MYSQL", "SQLITE", name="databasetype"),
            nullable=True,
        ),
        sa.Column("database_host", sa.Text(), nullable=True),
        sa.Column("database_port", sa.Text(), nullable=True),
        sa.Column("database_username", sa.Text(), nullable=True),
        sa.Column("database_password", sa.Text(), nullable=True),
        sa.Column("database_name", sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_workspaces_created_at"), "workspaces", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_workspaces_updated_at"), "workspaces", ["updated_at"], unique=False
    )
    op.create_table(
        "admin_api_key",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("token", sa.String(length=255), nullable=False),
        sa.Column("workspace_id", fief.models.generics.GUID(), nullable=False),
        sa.ForeignKeyConstraint(
            ["workspace_id"], ["workspaces.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("token"),
    )
    op.create_index(
        op.f("ix_admin_api_key_created_at"),
        "admin_api_key",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_admin_api_key_updated_at"),
        "admin_api_key",
        ["updated_at"],
        unique=False,
    )
    op.create_table(
        "workspace_users",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("workspace_id", fief.models.generics.GUID(), nullable=False),
        sa.Column("user_id", fief.models.generics.GUID(), nullable=False),
        sa.ForeignKeyConstraint(
            ["workspace_id"], ["workspaces.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_workspace_users_created_at"),
        "workspace_users",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_workspace_users_updated_at"),
        "workspace_users",
        ["updated_at"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_workspace_users_updated_at"), table_name="workspace_users")
    op.drop_index(op.f("ix_workspace_users_created_at"), table_name="workspace_users")
    op.drop_table("workspace_users")
    op.drop_index(op.f("ix_admin_api_key_updated_at"), table_name="admin_api_key")
    op.drop_index(op.f("ix_admin_api_key_created_at"), table_name="admin_api_key")
    op.drop_table("admin_api_key")
    op.drop_index(op.f("ix_workspaces_updated_at"), table_name="workspaces")
    op.drop_index(op.f("ix_workspaces_created_at"), table_name="workspaces")
    op.drop_table("workspaces")
    op.drop_index(
        op.f("ix_admin_session_tokens_updated_at"), table_name="admin_session_tokens"
    )
    op.drop_index(
        op.f("ix_admin_session_tokens_created_at"), table_name="admin_session_tokens"
    )
    op.drop_table("admin_session_tokens")
    # ### end Alembic commands ###
