# mypy-boto3-workdocs

[![PyPI - mypy-boto3-workdocs](https://img.shields.io/pypi/v/mypy-boto3-workdocs.svg?color=blue)](https://pypi.org/project/mypy-boto3-workdocs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-workdocs.svg?color=blue)](https://pypi.org/project/mypy-boto3-workdocs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.WorkDocs 1.12.32](https://boto3.amazonaws.com/v1/documentation/api/1.12.32/reference/services/workdocs.html#WorkDocs) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.6](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-workdocs](#mypy-boto3-workdocs)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `WorkDocs` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-workdocs]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import workdocs
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_workdocs as workdocs

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("workdocs")
client: workdocs.WorkDocsClient = boto3.client("workdocs")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: workdocs.WorkDocsClient = session.client("workdocs")


# Paginators need type annotation on creation
describe_activities_paginator: workdocs.DescribeActivitiesPaginator = client.get_paginator("describe_activities")
describe_comments_paginator: workdocs.DescribeCommentsPaginator = client.get_paginator("describe_comments")
describe_document_versions_paginator: workdocs.DescribeDocumentVersionsPaginator = client.get_paginator("describe_document_versions")
describe_folder_contents_paginator: workdocs.DescribeFolderContentsPaginator = client.get_paginator("describe_folder_contents")
describe_groups_paginator: workdocs.DescribeGroupsPaginator = client.get_paginator("describe_groups")
describe_notification_subscriptions_paginator: workdocs.DescribeNotificationSubscriptionsPaginator = client.get_paginator("describe_notification_subscriptions")
describe_resource_permissions_paginator: workdocs.DescribeResourcePermissionsPaginator = client.get_paginator("describe_resource_permissions")
describe_root_folders_paginator: workdocs.DescribeRootFoldersPaginator = client.get_paginator("describe_root_folders")
describe_users_paginator: workdocs.DescribeUsersPaginator = client.get_paginator("describe_users")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.