# REST framework JWT Auth

[![Build Status](https://travis-ci.org/Styria-Digital/django-rest-framework-jwt.svg?branch=master)](https://travis-ci.org/Styria-Digital/django-rest-framework-jwt)
[![Coverage](https://codecov.io/github/Styria-Digital/django-rest-framework-jwt/branch/master/graph/badge.svg)](https://codecov.io/github/Styria-Digital/django-rest-framework-jwt/branch/master)

JSON Web Token Authentication support for Django REST Framework

## Overview

This package provides [JSON Web Token Authentication][jwt-auth-spec] support
for [Django REST framework][drf].

If you want to know more about JWT, check out the following resources:

 - DjangoCon 2014 - JSON Web Tokens [Video][jwt-video] | [Slides][jwt-slides]
 - [Auth with JSON Web Tokens][auth-jwt]
 - [JWT.io][jwt-io]

## Requirements

-  Python 2.7, 3.4+
-  Django 1.11+
-  Django REST Framework 3.7+

## Installation

```bash
$ pip install drf-jwt
```

## Documentation & Support

Full documentation for the project is available at [docs][docs].

[jwt-auth-spec]: http://tools.ietf.org/html/draft-ietf-oauth-json-web-token
[drf]: http://django-rest-framework.org/
[jwt-video]: https://www.youtube.com/watch?v=825hodQ61bg
[jwt-slides]: https://speakerdeck.com/jpadilla/djangocon-json-web-tokens
[auth-jwt]: http://jpadilla.com/post/73791304724/auth-with-json-web-tokens
[jwt-io]: http://jwt.io/
[docs]: http://styria-digital.github.io/django-rest-framework-jwt
