# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MigrationsArgs', 'Migrations']

@pulumi.input_type
class MigrationsArgs:
    def __init__(__self__, *,
                 database_url: pulumi.Input[str],
                 source_url: pulumi.Input[str]):
        """
        The set of arguments for constructing a Migrations resource.
        :param pulumi.Input[str] database_url: Database URL to run the migrations on
        :param pulumi.Input[str] source_url: Source URL for the migrations
        """
        pulumi.set(__self__, "database_url", database_url)
        pulumi.set(__self__, "source_url", source_url)

    @property
    @pulumi.getter(name="databaseURL")
    def database_url(self) -> pulumi.Input[str]:
        """
        Database URL to run the migrations on
        """
        return pulumi.get(self, "database_url")

    @database_url.setter
    def database_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_url", value)

    @property
    @pulumi.getter(name="sourceURL")
    def source_url(self) -> pulumi.Input[str]:
        """
        Source URL for the migrations
        """
        return pulumi.get(self, "source_url")

    @source_url.setter
    def source_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_url", value)


class Migrations(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_url: Optional[pulumi.Input[str]] = None,
                 source_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Migrations resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_url: Database URL to run the migrations on
        :param pulumi.Input[str] source_url: Source URL for the migrations
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MigrationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Migrations resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MigrationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigrationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_url: Optional[pulumi.Input[str]] = None,
                 source_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigrationsArgs.__new__(MigrationsArgs)

            if database_url is None and not opts.urn:
                raise TypeError("Missing required property 'database_url'")
            __props__.__dict__["database_url"] = None if database_url is None else pulumi.Output.secret(database_url)
            if source_url is None and not opts.urn:
                raise TypeError("Missing required property 'source_url'")
            __props__.__dict__["source_url"] = None if source_url is None else pulumi.Output.secret(source_url)
        super(Migrations, __self__).__init__(
            'gomigrate:index:Migrations',
            resource_name,
            __props__,
            opts,
            remote=True)

