import numpy as np
import pandas as pd
from scipy import interpolate
import os
import platypos
d = platypos.__file__.rstrip("__init__.py/")
print(d)
#import pkgutil
#import sys
#d = os.path.dirname(sys.modules[platypos].__file__)
#data = open(os.path.join(d, 'mamajeck_mainsequence.csv'), 'rb').read()
#data = pkgutil.get_data(__package__, 'mamajeck_mainsequence.csv')
import io
data = b'SpT   Teff  logT   logL  Mbol  BCv    Mv    B-V    Bt-Vt  G-V    Bp-Rp  G-Rp   M_G    b-y    U-B    V-Rc   V-Ic   V-Ks   J-H    H-Ks    Ks-W1   W1-W2  W1-W3  W1-W4   M_J    M_Ks  i-z  z-Y  R_Rsun Msun  SpT\nA0V    9700  3.987  1.54  0.87 -0.24   1.11  0.000  0.013  0.007 -0.037  0.010  1.09   0.000 -0.005  0.001  0.004  0.041 -0.032  0.028   0.030  -0.041 -0.074 -0.022   1.07   1.07  ...  ...  2.09   2.3   A0V  \nA1V    9200  3.965  1.41  1.19 -0.15   1.34  0.040  0.056  0.000  0.011  0.036  1.32   0.017  0.033  0.019  0.044  0.101 -0.024  0.031   0.030  -0.036 -0.068 -0.023   1.25   1.24  ...  ...  2.00   2.15  A1V  \nA2V    8840  3.946  1.33  1.38 -0.10   1.48  0.070  0.091 -0.005  0.068  0.069  1.46   0.038  0.063  0.042  0.091  0.188 -0.010  0.034   0.029  -0.034 -0.067 -0.029   1.32   1.29  ...  ...  1.97   2.05  A2V  \nA3V    8550  3.932  1.29  1.49 -0.06   1.55  0.090  0.109 -0.009  0.096  0.084  1.52   0.055  0.077  0.050  0.108  0.228 -0.002  0.034   0.029  -0.033 -0.066 -0.029   1.35   1.32  ...  ...  2.01   2.00  A3V  \nA4V    8270  3.917  1.20  1.72 -0.04   1.76  0.140  0.166 -0.020  0.166  0.122  1.73   0.071  0.097  0.078  0.164  0.353  0.022  0.037   0.029  -0.031 -0.059 -0.021   1.47   1.41  ...  ...  1.94   1.90  A4V  \nA5V    8080  3.907  1.16  1.81 -0.03   1.84  0.160  0.185 -0.024  0.194  0.137  1.81   0.090  0.100  0.089  0.186  0.403  0.031  0.038   0.029  -0.030 -0.058 -0.021   1.51   1.44  ...  ...  1.94   1.85  A5V  \nA6V    8000  3.903  1.14  1.87 -0.02   1.89  0.170  0.194 -0.026  0.208  0.145  1.86   0.099  0.098  0.094  0.197  0.428  0.036  0.038   0.029  -0.030 -0.057 -0.018   1.54   1.46  ...  ...  1.93   1.83  A6V  \nA7V    7800  3.892  1.06  2.07  0.00   2.07  0.210  0.233 -0.036  0.263  0.174  2.03   0.107  0.091  0.117  0.242  0.528  0.055  0.040   0.029  -0.030 -0.056 -0.017   1.64   1.54  ...  ...  1.86   1.76  A7V  \nA8V    7500  3.874  0.97  2.29  0.00   2.29  0.250  0.274 -0.046  0.320  0.204  2.25   0.132  0.082  0.140  0.288  0.626  0.075  0.042   0.028  -0.028 -0.055 -0.009   1.78   1.66  ...  ...  1.81   1.67  A8V  \nA9V    7440  3.872  0.97  2.30  0.00   2.30  0.255  0.279 -0.047  0.327  0.208  2.26   0.145  0.080  0.143  0.294  0.638  0.078  0.043   0.028  -0.028 -0.055 -0.007   1.78   1.66  ...  ...  1.84   1.67  A9V  \nF0V    7220  3.857  0.89  2.50 -0.01   2.51  0.290  0.317 -0.060  0.377  0.230  2.46   0.158  0.053  0.166  0.339  0.732  0.098  0.045   0.028  -0.026 -0.050  0.003   1.90   1.76  ...  ...  1.79   1.59  F0V  \nF1V    7030  3.847  0.77  2.78 -0.01   2.79  0.330  0.350 -0.079  0.434  0.252  2.73   0.204  0.021  0.190  0.385  0.828  0.119  0.047   0.028  -0.026 -0.047  0.009   2.13   1.96  ...  ...  1.64   1.50  F1V  \nF2V    6810  3.833  0.70  2.97 -0.02   2.99  0.370  0.390 -0.093  0.490  0.279  2.92   0.250 -0.008  0.213  0.432  0.925  0.140  0.050   0.028  -0.027 -0.046  0.011   2.26   2.07  ...  ...  1.61   1.44  F2V  \nF3V    6720  3.827  0.67  3.05 -0.03   3.08  0.390  0.405 -0.100  0.518  0.293  3.01   0.263 -0.016  0.222  0.449  0.961  0.147  0.051   0.028  -0.028 -0.046  0.008   2.32   2.12  ...  ...  1.60   1.43  F3V  \nF4V    6640  3.822  0.61  3.19 -0.04   3.23  0.410  0.428 -0.107  0.546  0.307  3.16   0.277 -0.026  0.236  0.476  1.017  0.159  0.052   0.028  -0.029 -0.046  0.000   2.42   2.21  ...  ...  1.53   1.39  F4V  \nF5V    6510  3.814  0.54  3.36 -0.04   3.40  0.440  0.455 -0.116  0.587  0.329  3.32   0.290 -0.029  0.252  0.506  1.079  0.173  0.054   0.028  -0.030 -0.045 -0.004   2.55   2.32  ...  ...  1.46   1.33  F5V  \nF6V    6340  3.802  0.43  3.65 -0.05   3.70  0.484  0.504 -0.129  0.640  0.356  3.61   0.317 -0.021  0.276  0.553  1.185  0.199  0.057   0.028  -0.033 -0.045 -0.012   2.78   2.52  ...  ...  1.36   1.25  F6V  \nF7V    6240  3.795  0.36  3.81 -0.06   3.87  0.510  0.534 -0.135  0.670  0.372  3.77   0.332 -0.012  0.290  0.579  1.244  0.213  0.060   0.027  -0.036 -0.045 -0.013   2.90   2.63  ...  ...  1.30   1.21  F7V  \nF8V    6170  3.790  0.31  3.96 -0.07   4.01  0.530  0.558 -0.140  0.694  0.385  3.90   0.350  0.001  0.300  0.599  1.290  0.225  0.061   0.027  -0.039 -0.044 -0.016   3.01   2.72  ...  ...  1.25   1.18  F8V  \nF9V    6060  3.782  0.26  4.07 -0.08   4.15  0.552  0.587 -0.146  0.719  0.399  4.04   0.378  0.014  0.312  0.620  1.340  0.237  0.063   0.027  -0.041 -0.044 -0.014   3.11   2.81  ...  ...  1.23   1.14  F9V  \nF9.5V  6000  3.778  0.21  4.22 -0.08   4.29  0.572  0.615 -0.150  0.767  0.431  4.17   ...    0.033  0.323  0.640  1.385  0.249  0.065   0.027  -0.042 -0.043 -0.012   3.22   2.91  ...  ...  1.18   1.11  F9.5V\nG0V    5920  3.772  0.14  4.40 -0.09   4.45  0.596  0.650 -0.155  0.782  0.438  4.32   ...    0.058  0.336  0.664  1.440  0.262  0.067   0.027  -0.043 -0.043 -0.010   3.34   3.01  ...  ...  1.12   1.08  G0V  \nG1V    5880  3.769  0.13  4.40 -0.10   4.50  0.625  0.661 -0.162  0.803  0.448  4.37   ...    0.067  0.340  0.672  1.458  0.267  0.068   0.027  -0.044 -0.042 -0.010   3.38   3.04  ...  ...  1.12   1.07  G1V  \nG2V    5770  3.761  0.01  4.68 -0.11   4.79  0.650  0.724 -0.167  0.823  0.459  4.65   ...    0.133  0.363  0.713  1.564  0.293  0.073   0.028  -0.050 -0.040 -0.016   3.57   3.20  ...  ...  1.01   1.02  G2V  \nG3V    5720  3.757 -0.01  4.74 -0.12   4.86  0.660  0.739 -0.169  0.832  0.464  4.72   ...    0.152  0.368  0.722  1.590  0.299  0.074   0.028  -0.050 -0.040 -0.014   3.64   3.27  ...  ...  1.01   1.00  G3V  \nG4V    5680  3.754 -0.04  4.80 -0.13   4.94  0.670  0.757 -0.172  0.841  0.468  4.79   ...    0.175  0.374  0.733  1.621  0.307  0.075   0.028  -0.052 -0.041 -0.014   3.70   3.32  ...  ...  0.986  0.99  G4V  \nG5V    5660  3.753 -0.05  4.84 -0.13   4.98  0.680  0.764 -0.174  0.850  0.473  4.83   ...    0.185  0.377  0.738  1.635  0.310  0.076   0.028  -0.052 -0.041 -0.014   3.74   3.35  ...  ...  0.982  0.98  G5V  \nG6V    5590  3.747 -0.11  4.98 -0.15   5.13  0.700  0.796 -0.180  0.869  0.483  4.97   ...    0.227  0.388  0.758  1.691  0.324  0.079   0.028  -0.053 -0.040 -0.012   3.84   3.44  ...  ...  0.939  0.97  G6V  \nG7V    5530  3.743 -0.12  5.02 -0.16   5.18  0.710  0.809 -0.182  0.880  0.489  5.02   ...    0.243  0.393  0.766  1.712  0.329  0.080   0.028  -0.054 -0.040 -0.013   3.88   3.47  ...  ...  0.949  0.96  G7V  \nG8V    5490  3.734 -0.17  5.15 -0.17   5.32  0.730  0.842 -0.188  0.900  0.499  5.15   ...    0.284  0.404  0.786  1.768  0.342  0.082   0.028  -0.057 -0.039 -0.018   3.97   3.55  ...  ...  0.909  0.94  G8V  \nG9V    5340  3.728 -0.25  5.34 -0.21   5.55  0.775  0.894 -0.204  0.950  0.524  5.34   ...    0.358  0.423  0.820  1.861  0.365  0.087   0.029  -0.060 -0.038 -0.018   4.14   3.69  ...  ...  0.876  0.90  G9V  \nK0V    5280  3.723 -0.33  5.54 -0.22   5.76  0.816  0.944 -0.221  0.98   0.56   5.53   ...    0.436  0.443  0.853  1.953  0.387  0.091   0.030  -0.063 -0.037 -0.015   4.29   3.81  ...  ...  0.817  0.87  K0V  \nK0.5V  5240  3.719 -0.33  5.57 -0.23   5.80  0.825  0.955 -0.225  1.00   0.56   5.56   ...    0.456  0.448  0.862  1.977  0.393  0.092   0.030  -0.064 -0.038 -0.018   4.31   3.82  ...  ...  0.828  0.86  K0.5V\nK1V    5170  3.713 -0.36  5.65 -0.26   5.89  0.842  0.976 -0.232  1.01   0.56   5.63   ...    0.491  0.457  0.879  2.021  0.402  0.094   0.030  -0.064 -0.038 -0.013   4.37   3.87  ...  ...  0.814  0.85  K1V  \nK1.5V  5140  3.711 -0.39  5.70 -0.27   5.97  0.860  0.999 -0.241  1.05   0.58   5.69   ...    0.528  0.467  0.895  2.066  0.412  0.096   0.030  -0.063 -0.037 -0.016   4.41   3.90  ...  ...  0.809  0.82  K1.5V\nK2V    5040  3.702 -0.47  5.88 -0.29   6.19  0.884  1.035 -0.254  1.10   0.62   5.89   ...    0.581  0.482  0.920  2.132  0.427  0.098   0.031  -0.068 -0.037 -0.009   4.57   4.04  ...  ...  0.763  0.78  K2V  \nK2.5V  4990  3.698 -0.51  6.02 -0.32   6.34  0.938  1.101 -0.288  1.17   0.64   6.04   ...    0.691  0.513  0.974  2.274  0.459  0.104   0.032  -0.071 -0.032 -0.006   4.63   4.07  ...  ...  0.742  0.76  K2.5V\nK3V    4830  3.684 -0.58  6.16 -0.41   6.57  0.986  1.150 -0.322  1.21   0.66   6.26   ...    0.776  0.537  1.013  2.380  0.483  0.109   0.033  -0.071 -0.031 -0.008   4.76   4.16  ...  ...  0.729  0.75  K3V  \nK3.5V  4700  3.672 -0.64  6.34 -0.45   6.79  1.050  1.239 -0.371  1.27   0.68   6.42   ...    0.917  0.592  1.108  2.582  0.520  0.118   0.036  -0.074 -0.031 -0.005   4.85   4.21  ...  ...  0.720  0.73  K3.5V\nK4V    4600  3.663 -0.67  6.42 -0.56   6.98  1.100  1.306 -0.412  1.32   0.70   6.55   ...    1.004  0.640  1.190  2.733  0.544  0.125   0.039  -0.073 -0.031  0.009   4.92   4.25  ...  ...  0.726  0.72  K4V  \nK4.5V  4540  3.657 -0.68  6.44 -0.60   7.04  1.116  1.328 -0.425  1.38   0.72   6.62   ...    1.028  0.654  1.216  2.781  0.552  0.127   0.040  -0.073 -0.030  0.017   4.94   4.26  ...  ...  0.737  0.71  K4.5V\nK5V    4410  3.644 -0.78  6.68 -0.68   7.36  1.150  1.373 -0.454  1.45   0.74   6.95   ...    1.081  0.685  1.272  2.883  0.568  0.132   0.042  -0.073 -0.029  0.019   5.18   4.48  ...  ...  0.698  0.68  K5V  \nK5.5V  4330  3.636 -0.84  6.85 -0.75   7.60  1.200  1.414 -0.495  1.51   0.76   7.16   ...    1.144  0.728  1.357  3.034  0.591  0.139   0.045   ...    ...    ...     5.30   4.57  ...  ...  0.672  0.66  K5.5V\nK6V    4230  3.626 -0.90  6.99 -0.81   7.80  1.240  1.439 -0.528  1.58   0.79   7.32   ...    1.184  0.759  1.420  3.143  0.601  0.148   0.049   ...    ...    ...     5.41   4.66  ...  ...  0.661  0.65  K6V  \nK6.5V  4190  3.622 -0.96  7.09 -0.92   8.01  1.310  1.491 -0.581  1.64   0.83   7.49   ...    1.213  0.796  1.505  3.288  0.613  0.159   0.055   ...    ...    ...     5.56   4.78  ...  ...  0.656  0.64  K6.5V\nK7V    4070  3.610 -0.98  7.18 -0.95   8.15  1.330  1.506 -0.595  1.71   0.87   7.58   ...    1.221  0.806  1.529  3.330  0.617  0.162   0.057   ...    ...    ...     5.60   4.82  ...  ...  0.654  0.63  K7V  \nK8V    4000  3.602 -1.10  7.44 -1.03   8.47  1.380  1.562 -0.628  1.72   0.88   7.84   ...    1.216  0.843  1.632  3.487  0.623  0.176   0.081   ...    ...    ...     5.78   4.98  ...  ...  0.587  0.59  K8V  \nK9V    3940  3.595 -1.18  7.59 -1.10   8.69  1.420  1.593 -0.69   1.78   0.90   8.00   ...    1.210  0.866  1.699  3.584  0.625  0.184   0.101   ...    ...    ...     5.92   5.11  ...  ...  0.552  0.56  K9V  \nM0V    3870  3.588 -1.20  7.75 -1.16   8.91  1.408  1.623 -0.65   1.84   0.92   8.26   ...    1.204  0.889  1.766  3.680  0.626  0.193   0.122   ...    ...    ...     6.04   5.22  0.33 ...  0.559  0.55  M0V  \nM0.5V  3800  3.580 -1.27  7.90 -1.38   9.20  1.441  ...   -0.74   1.97   0.96   8.46   ...    1.184  0.924  1.886  3.84   0.620  0.208   0.130   ...    ...    ...     6.19   5.36  0.37 ...  0.535  0.54  M0.5V\nM1V    3700  3.568 -1.40  8.25 -1.44   9.69  1.475  ...   -0.82   2.09   1.01   8.87   ...    1.172  0.959  2.019  4.02   0.613  0.225   0.137   ...    ...    ...     6.51   5.67  0.41 ...  0.496  0.49  M1V  \nM1.5V  3650  3.562 -1.47  8.40 -1.57   9.97  1.486  ...   -0.85   2.14   1.03   9.12   ...    1.170  0.978  2.089  4.12   0.607  0.228   0.105   ...    ...    ...     6.69   5.85  0.47 ...  0.460  0.47  M1.5V\nM2V    3550  3.550 -1.57  8.65 -1.65  10.30  1.500  ...   -0.92   2.25   1.06   9.38   ...    1.170  1.001  2.173  4.24   0.600  0.234   0.110   ...    ...    ...     6.89   6.06  0.53 ...  0.434  0.44  M2V  \nM2.5V  3500  3.544 -1.68  8.94 -1.76  10.70  1.522  ...   -1.02   2.39   1.10   9.68   ...    1.175  1.041  2.306  4.43   0.589  0.244   0.117   ...    ...    ...     7.01   6.27  0.57 ...  0.393  0.40  M2.5V\nM3V    3410  3.533 -1.78  9.17 -1.97  11.14  1.544  ...   -1.09   2.49   1.12  10.05   ...    1.181  1.079  2.420  4.60   0.579  0.252   0.122   ...    ...    ...     7.40   6.54  0.61 ...  0.369  0.36  M3V  \nM3.5V  3250  3.512 -2.07  9.92 -2.27  12.19  1.602  ...   -1.29   2.71   1.17  10.90   ...    1.200  1.178  2.680  5.00   0.558  0.269   0.132   ...    ...    ...     8.02   7.19  0.66 ...  0.291  0.26  M3.5V\nM4V    3200  3.505 -2.20 10.21 -2.59  12.80  1.661  ...   -1.41   2.95   1.24  11.39   ...    1.222  1.241  2.831  5.25   0.557  0.282   0.139   ...    ...    ...     8.39   7.55  0.71 ...  0.258  0.22  M4V  \nM4.5V  3100  3.491 -2.31 10.52 -3.05  13.57  1.72   ...   -1.55   3.13   1.27  12.02   ...    1.23   1.345  3.073  5.64   0.564  0.301   ...     ...    ...    ...     8.79   7.93  0.81 ...  0.243  0.18  M4.5V\nM5V    3030  3.481 -2.52 11.02 -3.28  14.30  1.874  ...   -1.74   3.36   1.33  12.56   ...    1.24   1.446  3.277  5.94   0.580  0.311   ...     0.17   ...    ...     9.25   8.36  0.91 0.47 0.199  0.16  M5V  \nM5.5V  3000  3.477 -2.79 11.71 -3.80  15.51  1.91   ...   -2.01   3.70   1.37  13.50   ...    1.3    1.656  3.664  6.50   0.588  0.329   ...     0.19   ...    ...     9.93   9.01  1.13 0.52 0.149  0.12  M5.5V\nM6V    2850  3.455 -3.02 12.26 -4.36  16.62  2.00   ...   -2.14   3.95   1.45  14.48   ...    1.3    1.950  4.13   7.30   0.605  0.352   ...     0.21   ...    ...    10.28   9.32  1.45 0.60 0.127  0.10  M6V  \nM6.5V  2710  3.433 -3.09 12.47 -4.60  17.07  2.06   ...   -2.64   4.41   1.48  14.32   ...    ...    2.003  4.31   7.60   0.609  0.364   ...     0.22   ...    ...    10.47   9.47  1.58 0.64 0.129  0.097 M6.5V\nM7V    2650  3.423 -3.21 12.75 -5.06  17.81  2.06   ...   -2.98   4.75   1.52  14.83   ...    ...    2.180  4.45   8.05   0.613  0.386   ...     0.24   ...    ...    10.76   9.76  1.77 0.70 0.118  0.090 M7V  \nM7.5V  2600  3.415 -3.29 12.97 -5.46  18.42  2.17   ...   -3.03   4.77   1.54  15.33   ...    ...    2.160  4.56   8.45   0.650  0.422   ...     0.25   ...    ...    10.68   9.97  1.85 0.74 0.112  0.089 M7.5V\nM8V    2500  3.398 -3.36 13.14 -5.70  18.84  2.20   ...   -3.08   4.80   1.57  15.73   ...    ...    2.150  4.64   8.73   0.670  0.450   ...     0.26   ...    ...    11.23  10.11  1.93 0.77 0.111  0.082 M8V  \nM8.5V  2440  3.387 -3.44 13.34 -5.80  19.14  ...    ...   -3.04   5.03   1.58  16.05   ...    ...    1.967  4.71   8.92   0.685  0.470   ...     0.265  ...    ...    11.45  10.22  1.96 0.80 0.107  0.081 M8.5V\nM9V    2400  3.380 -3.57 13.67 -5.90  19.36  ...    ...   -3.00   4.78   1.59  16.29   ...    ...    1.890  4.75   9.00   0.749  0.480   ...     0.27   ...    ...    11.53  10.30  1.99 0.82 0.095  0.079 M9V  \nM9.5V  2320  3.365 -3.55 13.62 -6.13  19.75  ...    ...   -3.10   ...    1.63  16.33   ...    ...    2.510  4.79   9.30   0.826  0.505   ...     0.27   ...    ...    11.78  10.45  2.00 0.84 0.104  0.078 M9.5V\n'

def mass_lum_relation_mamajek():
    """ main-sequencen mass-luminosity relation from Erik Mamajek 
    (http://www.pas.rochester.edu/~emamajek/EEM_dwarf_UBVIJHK_colors_Teff.dat)
    
    Returns:
    --------
    logL_from_M (function): interpolation function which takes a mass 
    value and returns the log10(bolometric luminosity)
    """ 

    df = pd.read_csv(io.StringIO(data.decode("utf-8")), sep="\s+")
    logL_from_M = interpolate.interp1d(df["Msun"], df["logL"], kind="linear")

    return logL_from_M
