"""ASCII formatter."""


from dbt_score.evaluation import ModelResultsType
from dbt_score.formatters import Formatter
from dbt_score.models import Model
from dbt_score.scoring import Score, Scorer

# ruff: noqa: E501 [line-too-long]

gold = """
\x1B[38;5;75m              ______________        \x1B[38;5;25m_____________
              \x1B[38;5;75m"@@@@@@@@@@@@@@_    \x1B[38;5;25m/@@@@@@@@@@@@@@"
                \x1B[38;5;75m@@@@@@@@@@@@@@L  \x1B[38;5;25m@@@@@@@@@@@@@@@
                 \x1B[38;5;75mf@@@@@@@@@@@@@h\x1B[38;5;25m%@@@@@@@@@@@@@P
                  \x1B[38;5;75m'@@@@@@@@@@@@@g\x1B[38;5;25mt@@@@@@@@@@@"
                    \x1B[38;5;75m@@@@@@@@@@@@@@\x1B[38;5;25m\\@@@@@@@@@
                     \x1B[38;5;75m\\@@@@@@@@@@@@@\x1B[38;5;25m"@@@@@@P
                      \x1B[38;5;75m'@@@@@@@@@@@@@\x1B[38;5;25m'@@@@'
                       \x1B[38;5;220m_\x1B[38;5;75m%@@@@@@@@@@@@\x1B[38;5;25m'""\x1B[38;5;220m_,
                      !@@\x1B[38;5;75m\"\"\"\"\"\"\"\"\"\"\"\"\" \x1B[38;5;220m$@g
                        '"0@gT\x1B[38;5;231mg\x1B[38;5;220mg@@@@g@D"
                           __@g@@@@@__
                      _-"\x1B[38;5;231m~m*"\x1B[38;5;208m_ommmq_\x1B[38;5;220m""*@@p_
                   _p\x1B[38;5;231m_@>\x1B[38;5;208m_8"\x1B[38;5;220m_g@@@@@@@@p\x1B[38;5;208m"<@_\x1B[38;5;220m+@@_
                 ,@\x1B[38;5;231m_@"\x1B[38;5;208m8\x1B[38;5;220m_@@@@@@@B=""@@@@@@a\x1B[38;5;208m<g\x1B[38;5;220m"@@_
                ,@\x1B[38;5;231m;F\x1B[38;5;208md\x1B[38;5;220m_@@@@@@'\x1B[38;5;208mg@@@@@\x1B[38;5;220m@@@@@@@@p\x1B[38;5;208mta\x1B[38;5;220m0@a
                @@\x1B[38;5;208m,@\x1B[38;5;220mJ@@@@@@@\x1B[38;5;214m'\x1B[38;5;208m@D%@@@\x1B[38;5;220m@@@@@@@@@@\x1B[38;5;208mTA\x1B[38;5;220m@@;
               |@@\x1B[38;5;208m@'\x1B[38;5;220m@@@@@@@@@@@\x1B[38;5;208m[@@@\x1B[38;5;220m@@@@@@@@@\x1B[38;5;231m_\x1B[38;5;220m|\x1B[38;5;208m@\x1B[38;5;220m|@@
               [@@\x1B[38;5;208m@\x1B[38;5;214m'\x1B[38;5;220m@@@@@@@@@@@\x1B[38;5;208m[@@@\x1B[38;5;220m@@@@@@@@F\x1B[38;5;231m@\x1B[38;5;220m|\x1B[38;5;208m@\x1B[38;5;214m'\x1B[38;5;220m@@
               '@@\x1B[38;5;208m'g\x1B[38;5;220m0@@@@@@@@@@\x1B[38;5;208m[@@@\x1B[38;5;220m@@@@@@@@\x1B[38;5;231mJF\x1B[38;5;208m,@\x1B[38;5;220m[@F
                T@@\x1B[38;5;208mTp\x1B[38;5;220m%@@@@@@@\x1B[38;5;208m;g@@@@gg\x1B[38;5;220m@@@@"\x1B[38;5;231mgF\x1B[38;5;208m_@\x1B[38;5;220m_@@
                 '@@_\x1B[38;5;208m@_\x1B[38;5;220m8@@@@@\x1B[38;5;208m"BBBBBB?\x1B[38;5;220m@B"\x1B[38;5;231mgP\x1B[38;5;208m_gP\x1B[38;5;220mj@P
                   <@@_\x1B[38;5;208m%q\x1B[38;5;220m"4@@@@@@@@@@_\x1B[38;5;231m"\x1B[38;5;208m__@"\x1B[38;5;220mg@P
                      <@@a\x1B[38;5;208m"<Bmp____gmD>\x1B[38;5;220m_g@P"
                          ""=B@@@@@BD>"
\x1B[0m"""

wip = """
\x1B[38;5;220m       __gmmq__                                  ,_ommq__
     ,@"\x1B[38;5;202mg\x1B[38;5;224m.\x1B[38;5;202m0D\x1B[38;5;224m,\x1B[38;5;202mg_\x1B[38;5;220m@,                              ,@"\x1B[38;5;202mg tB\x1B[38;5;224m,\x1B[38;5;202m@_\x1B[38;5;220mQ_
     @\x1B[38;5;202m;_\x1B[38;5;224m~o@@g~\x1B[38;5;202m_;\x1B[38;5;220m@                              @\x1B[38;5;202m._\x1B[38;5;224m~o@@g~~\x1B[38;5;202m1\x1B[38;5;220m@\x1B[38;5;94m.
     \x1B[38;5;220m0L\x1B[38;5;202mQ \x1B[38;5;224m"<F" \x1B[38;5;202m0\x1B[38;5;220m_@                              VL\x1B[38;5;202m@'\x1B[38;5;224m""P"\x1B[38;5;202m_%'\x1B[38;5;220m@
      "B_\x1B[38;5;202m""\x1B[38;5;220m_\x1B[38;5;202m"\x1B[38;5;220m_8"                                '8_\x1B[38;5;202m""\x1B[38;5;220m_\x1B[38;5;202m"\x1B[38;5;220m_@"
       \x1B[38;5;214m~~~~~~~~,                                 ~~~~~~~~,
  \x1B[38;5;247m.===\x1B[38;5;214m[@@@@@@@@g\x1B[38;5;247m================================\x1B[38;5;214m|@@@@@@@@@\x1B[38;5;247m===.
  \x1B[38;5;220m@@@@"\x1B[38;5;234mg@@@@@@@@"\x1B[38;5;220mg@@@@@@@"\x1B[38;5;234mg@@@@@@@B"\x1B[38;5;220mg@@@@@@B"\x1B[38;5;234m@@@@@@@@D\x1B[38;5;220m_@@@@@@@
  @P\x1B[38;5;234m_@@@@@@@@P\x1B[38;5;220m_@@@@@@@P\x1B[38;5;234m_@@@@@@@@P\x1B[38;5;220m_@@@@@@@P\x1B[38;5;234m_@@@@@@@@>\x1B[38;5;220mo@@@@@@@"\x1B[38;5;234mo
  g@@@@@@@@"\x1B[38;5;220mg@@@@@@@"\x1B[38;5;234mg@@@@@@@B"\x1B[38;5;220mg@@@@@@B"\x1B[38;5;234m@@@@@@@@D\x1B[38;5;220m_@@@@@@@P\x1B[38;5;234m_@@@
  @@@@@@P\x1B[38;5;220m_@@@@@@@P\x1B[38;5;234m_@@@@@@@@P\x1B[38;5;220m_@@@@@@@P\x1B[38;5;234m_@@@@@@@@>\x1B[38;5;220mo@@@@@@@"\x1B[38;5;234mo@@@@@
  @@@@"\x1B[38;5;220mg@@@@@@@"\x1B[38;5;234mg@@@@@@@B"\x1B[38;5;220mg@@@@@@B"\x1B[38;5;234m@@@@@@@@D\x1B[38;5;220m_@@@@@@@P\x1B[38;5;234m_@@@@@@@@
  @P\x1B[38;5;220m_@@@@@@@P\x1B[38;5;234m_@@@@@@@@P\x1B[38;5;220m_@@@@@@@P\x1B[38;5;234m_@@@@@@@@>\x1B[38;5;220mo@@@@@@@"\x1B[38;5;234mo@@@@@@@@"\x1B[38;5;220mg
  g@@@@@@@"\x1B[38;5;234mg@@@@@@@B"\x1B[38;5;220mg@@@@@@B"\x1B[38;5;234m@@@@@@@@D\x1B[38;5;220m_@@@@@@@P\x1B[38;5;234m_@@@@@@@@P\x1B[38;5;220m_@@@
  "BBBBP\x1B[38;5;234m.BBBBBBBBP\x1B[38;5;220m.BBBBBBBP\x1B[38;5;234m:BBBBBBBB>\x1B[38;5;220moBBBBBBB"\x1B[38;5;234moBBBBBBBB"\x1B[38;5;220maBBBB>
        \x1B[38;5;247m@@@@@@                                    @@@@@@
        \x1B[38;5;250m@@@@@@                                    @@@@@@
        @@@@@@                                    @@@@@@
        @@@@@@                                    @@@@@@
        @@@@@@                                    @@@@@@
        @@@@@@                                    @@@@@@
        @@@@@@                                    @@@@@@
        "=BBP"                                    "=BBP"
\x1B[0m"""


class ASCIIFormatter(Formatter):
    """Formatter for ASCII medals in the terminal."""

    def model_evaluated(
        self, model: Model, results: ModelResultsType, score: Score
    ) -> None:
        """Callback when a model has been evaluated."""
        pass

    def project_evaluated(self, score: Score) -> None:
        """Callback when a project has been evaluated."""
        if score.value == Scorer.max_score:
            print(gold)
        else:
            print(wip)
