# coding: utf-8

"""
    Neurograph Core

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from neurograph.v1.models.reporting_chart_defaults import ReportingChartDefaults
from neurograph.v1.models.reporting_header_config import ReportingHeaderConfig
from neurograph.v1.models.reporting_primary_analysis import ReportingPrimaryAnalysis
from neurograph.v1.models.reporting_visualization import ReportingVisualization
from typing import Optional, Set
from typing_extensions import Self

class ReportingContentConfig(BaseModel):
    """
    ReportingContentConfig
    """ # noqa: E501
    chart_defaults: Optional[ReportingChartDefaults] = Field(default=None, alias="chartDefaults")
    header: Optional[ReportingHeaderConfig] = None
    primary_analysis: Optional[ReportingPrimaryAnalysis] = Field(default=None, alias="primaryAnalysis")
    visualizations: Optional[List[ReportingVisualization]] = None
    __properties: ClassVar[List[str]] = ["chartDefaults", "header", "primaryAnalysis", "visualizations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReportingContentConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chart_defaults
        if self.chart_defaults:
            _dict['chartDefaults'] = self.chart_defaults.to_dict()
        # override the default output from pydantic by calling `to_dict()` of header
        if self.header:
            _dict['header'] = self.header.to_dict()
        # override the default output from pydantic by calling `to_dict()` of primary_analysis
        if self.primary_analysis:
            _dict['primaryAnalysis'] = self.primary_analysis.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in visualizations (list)
        _items = []
        if self.visualizations:
            for _item_visualizations in self.visualizations:
                if _item_visualizations:
                    _items.append(_item_visualizations.to_dict())
            _dict['visualizations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReportingContentConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chartDefaults": ReportingChartDefaults.from_dict(obj["chartDefaults"]) if obj.get("chartDefaults") is not None else None,
            "header": ReportingHeaderConfig.from_dict(obj["header"]) if obj.get("header") is not None else None,
            "primaryAnalysis": ReportingPrimaryAnalysis.from_dict(obj["primaryAnalysis"]) if obj.get("primaryAnalysis") is not None else None,
            "visualizations": [ReportingVisualization.from_dict(_item) for _item in obj["visualizations"]] if obj.get("visualizations") is not None else None
        })
        return _obj


