# coding: utf-8

"""
    Neurograph Core

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from neurograph.v1.models.personas_kpi import PersonasKpi
from neurograph.v1.models.personas_persona_factor import PersonasPersonaFactor
from neurograph.v1.models.personas_persona_insight import PersonasPersonaInsight
from neurograph.v1.models.personas_persona_personality_trait import PersonasPersonaPersonalityTrait
from typing import Optional, Set
from typing_extensions import Self

class PersonasPersona(BaseModel):
    """
    PersonasPersona
    """ # noqa: E501
    age: Optional[Union[StrictFloat, StrictInt]] = None
    description: Optional[StrictStr] = None
    factors: Optional[List[PersonasPersonaFactor]] = None
    female: Optional[Union[StrictFloat, StrictInt]] = None
    id: Optional[StrictStr] = None
    income: Optional[StrictStr] = None
    insights: Optional[List[PersonasPersonaInsight]] = None
    kpis: Optional[List[PersonasKpi]] = None
    male: Optional[Union[StrictFloat, StrictInt]] = None
    metadata: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    persona_seed_id: Optional[StrictStr] = None
    personality_background: Optional[StrictStr] = None
    personality_first_name: Optional[StrictStr] = None
    personality_img_url: Optional[StrictStr] = None
    personality_last_name: Optional[StrictStr] = None
    personality_quote: Optional[StrictStr] = None
    personality_traits: Optional[List[PersonasPersonaPersonalityTrait]] = None
    personality_video_url: Optional[StrictStr] = None
    positioning_statement: Optional[StrictStr] = None
    seed_uid: Optional[StrictStr] = None
    summary_detail: Optional[StrictStr] = None
    summary_headline: Optional[StrictStr] = None
    tag: Optional[StrictStr] = None
    ts_created: Optional[StrictInt] = None
    ts_updated: Optional[StrictInt] = None
    value: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["age", "description", "factors", "female", "id", "income", "insights", "kpis", "male", "metadata", "name", "persona_seed_id", "personality_background", "personality_first_name", "personality_img_url", "personality_last_name", "personality_quote", "personality_traits", "personality_video_url", "positioning_statement", "seed_uid", "summary_detail", "summary_headline", "tag", "ts_created", "ts_updated", "value"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PersonasPersona from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in factors (list)
        _items = []
        if self.factors:
            for _item_factors in self.factors:
                if _item_factors:
                    _items.append(_item_factors.to_dict())
            _dict['factors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in insights (list)
        _items = []
        if self.insights:
            for _item_insights in self.insights:
                if _item_insights:
                    _items.append(_item_insights.to_dict())
            _dict['insights'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in kpis (list)
        _items = []
        if self.kpis:
            for _item_kpis in self.kpis:
                if _item_kpis:
                    _items.append(_item_kpis.to_dict())
            _dict['kpis'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in personality_traits (list)
        _items = []
        if self.personality_traits:
            for _item_personality_traits in self.personality_traits:
                if _item_personality_traits:
                    _items.append(_item_personality_traits.to_dict())
            _dict['personality_traits'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PersonasPersona from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "age": obj.get("age"),
            "description": obj.get("description"),
            "factors": [PersonasPersonaFactor.from_dict(_item) for _item in obj["factors"]] if obj.get("factors") is not None else None,
            "female": obj.get("female"),
            "id": obj.get("id"),
            "income": obj.get("income"),
            "insights": [PersonasPersonaInsight.from_dict(_item) for _item in obj["insights"]] if obj.get("insights") is not None else None,
            "kpis": [PersonasKpi.from_dict(_item) for _item in obj["kpis"]] if obj.get("kpis") is not None else None,
            "male": obj.get("male"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "persona_seed_id": obj.get("persona_seed_id"),
            "personality_background": obj.get("personality_background"),
            "personality_first_name": obj.get("personality_first_name"),
            "personality_img_url": obj.get("personality_img_url"),
            "personality_last_name": obj.get("personality_last_name"),
            "personality_quote": obj.get("personality_quote"),
            "personality_traits": [PersonasPersonaPersonalityTrait.from_dict(_item) for _item in obj["personality_traits"]] if obj.get("personality_traits") is not None else None,
            "personality_video_url": obj.get("personality_video_url"),
            "positioning_statement": obj.get("positioning_statement"),
            "seed_uid": obj.get("seed_uid"),
            "summary_detail": obj.get("summary_detail"),
            "summary_headline": obj.get("summary_headline"),
            "tag": obj.get("tag"),
            "ts_created": obj.get("ts_created"),
            "ts_updated": obj.get("ts_updated"),
            "value": obj.get("value")
        })
        return _obj


