# coding: utf-8

"""
    Neurograph Core

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from neurograph.v1.models.knowledge_entity_extra import KnowledgeEntityExtra
from neurograph.v1.models.knowledge_entity_relations import KnowledgeEntityRelations
from neurograph.v1.models.knowledge_entity_schema import KnowledgeEntitySchema
from typing import Optional, Set
from typing_extensions import Self

class KnowledgeEntity(BaseModel):
    """
    KnowledgeEntity
    """ # noqa: E501
    client_id: Optional[StrictStr] = Field(default=None, description="nullable.")
    data: Optional[Dict[str, Any]] = None
    ext: Optional[KnowledgeEntityExtra] = None
    extra: Optional[Dict[str, Any]] = None
    kind: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    relations: Optional[KnowledgeEntityRelations] = None
    var_schema: Optional[KnowledgeEntitySchema] = Field(default=None, alias="schema")
    source_id: Optional[StrictStr] = None
    source_updated_at: Optional[StrictInt] = None
    ts_updated: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["client_id", "data", "ext", "extra", "kind", "name", "relations", "schema", "source_id", "source_updated_at", "ts_updated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KnowledgeEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ext
        if self.ext:
            _dict['ext'] = self.ext.to_dict()
        # override the default output from pydantic by calling `to_dict()` of relations
        if self.relations:
            _dict['relations'] = self.relations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KnowledgeEntity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "client_id": obj.get("client_id"),
            "data": obj.get("data"),
            "ext": KnowledgeEntityExtra.from_dict(obj["ext"]) if obj.get("ext") is not None else None,
            "extra": obj.get("extra"),
            "kind": obj.get("kind"),
            "name": obj.get("name"),
            "relations": KnowledgeEntityRelations.from_dict(obj["relations"]) if obj.get("relations") is not None else None,
            "schema": KnowledgeEntitySchema.from_dict(obj["schema"]) if obj.get("schema") is not None else None,
            "source_id": obj.get("source_id"),
            "source_updated_at": obj.get("source_updated_at"),
            "ts_updated": obj.get("ts_updated")
        })
        return _obj


