# coding: utf-8

"""
    Neurograph Core

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from neurograph.v1.models.db_user_client_role import DbUserClientRole
from neurograph.v1.models.db_user_org_role import DbUserOrgRole
from neurograph.v1.models.db_user_role import DbUserRole
from typing import Optional, Set
from typing_extensions import Self

class DbUserInDb(BaseModel):
    """
    DbUserInDb
    """ # noqa: E501
    client_roles: Optional[List[DbUserClientRole]] = None
    display_name: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    firebase_uid: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    org_roles: Optional[List[DbUserOrgRole]] = None
    roles: Optional[List[DbUserRole]] = None
    ts_created: Optional[StrictInt] = None
    ts_updated: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["client_roles", "display_name", "email", "firebase_uid", "id", "org_roles", "roles", "ts_created", "ts_updated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DbUserInDb from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in client_roles (list)
        _items = []
        if self.client_roles:
            for _item_client_roles in self.client_roles:
                if _item_client_roles:
                    _items.append(_item_client_roles.to_dict())
            _dict['client_roles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in org_roles (list)
        _items = []
        if self.org_roles:
            for _item_org_roles in self.org_roles:
                if _item_org_roles:
                    _items.append(_item_org_roles.to_dict())
            _dict['org_roles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in roles (list)
        _items = []
        if self.roles:
            for _item_roles in self.roles:
                if _item_roles:
                    _items.append(_item_roles.to_dict())
            _dict['roles'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DbUserInDb from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "client_roles": [DbUserClientRole.from_dict(_item) for _item in obj["client_roles"]] if obj.get("client_roles") is not None else None,
            "display_name": obj.get("display_name"),
            "email": obj.get("email"),
            "firebase_uid": obj.get("firebase_uid"),
            "id": obj.get("id"),
            "org_roles": [DbUserOrgRole.from_dict(_item) for _item in obj["org_roles"]] if obj.get("org_roles") is not None else None,
            "roles": [DbUserRole.from_dict(_item) for _item in obj["roles"]] if obj.get("roles") is not None else None,
            "ts_created": obj.get("ts_created"),
            "ts_updated": obj.get("ts_updated")
        })
        return _obj


