# coding: utf-8

"""
    Neurograph Core

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from neurograph.v1.models.client_info import ClientInfo
from neurograph.v1.models.client_metadata import ClientMetadata
from neurograph.v1.models.client_organization_detail import ClientOrganizationDetail
from typing import Optional, Set
from typing_extensions import Self

class ClientMetadataResponse(BaseModel):
    """
    ClientMetadataResponse
    """ # noqa: E501
    client: Optional[ClientInfo] = None
    error: Optional[StrictStr] = None
    metadata: Optional[List[ClientMetadata]] = None
    organization: Optional[ClientOrganizationDetail] = None
    __properties: ClassVar[List[str]] = ["client", "error", "metadata", "organization"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClientMetadataResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of client
        if self.client:
            _dict['client'] = self.client.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in metadata (list)
        _items = []
        if self.metadata:
            for _item_metadata in self.metadata:
                if _item_metadata:
                    _items.append(_item_metadata.to_dict())
            _dict['metadata'] = _items
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClientMetadataResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "client": ClientInfo.from_dict(obj["client"]) if obj.get("client") is not None else None,
            "error": obj.get("error"),
            "metadata": [ClientMetadata.from_dict(_item) for _item in obj["metadata"]] if obj.get("metadata") is not None else None,
            "organization": ClientOrganizationDetail.from_dict(obj["organization"]) if obj.get("organization") is not None else None
        })
        return _obj


