# coding: utf-8

"""
    Neurograph Core

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from neurograph.v1.models.knowledge_customer_response import KnowledgeCustomerResponse
from neurograph.v1.models.knowledge_order_response import KnowledgeOrderResponse
from neurograph.v1.models.knowledge_product_response import KnowledgeProductResponse
from neurograph.v1.models.knowledge_store_response import KnowledgeStoreResponse

from neurograph.v1.api_client import ApiClient, RequestSerialized
from neurograph.v1.api_response import ApiResponse
from neurograph.v1.rest import RESTResponseType


class KnowledgeExtractApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def api_v1_knowledge_extract_customer_get(
        self,
        client_id: Optional[StrictStr] = None,
        email: Optional[StrictStr] = None,
        first_name: Optional[StrictStr] = None,
        last_name: Optional[StrictStr] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        phone: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> KnowledgeCustomerResponse:
        """Get Knowledge Customers

        Search customers by optional first/last/email/phone with prefix match (ILIKE '%') scoped to a client.

        :param client_id:
        :type client_id: str
        :param email:
        :type email: str
        :param first_name:
        :type first_name: str
        :param last_name:
        :type last_name: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param phone:
        :type phone: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_customer_get_serialize(
            client_id=client_id,
            email=email,
            first_name=first_name,
            last_name=last_name,
            limit=limit,
            offset=offset,
            phone=phone,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeCustomerResponse",
            '400': "KnowledgeCustomerResponse",
            '503': "KnowledgeCustomerResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_knowledge_extract_customer_get_with_http_info(
        self,
        client_id: Optional[StrictStr] = None,
        email: Optional[StrictStr] = None,
        first_name: Optional[StrictStr] = None,
        last_name: Optional[StrictStr] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        phone: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[KnowledgeCustomerResponse]:
        """Get Knowledge Customers

        Search customers by optional first/last/email/phone with prefix match (ILIKE '%') scoped to a client.

        :param client_id:
        :type client_id: str
        :param email:
        :type email: str
        :param first_name:
        :type first_name: str
        :param last_name:
        :type last_name: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param phone:
        :type phone: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_customer_get_serialize(
            client_id=client_id,
            email=email,
            first_name=first_name,
            last_name=last_name,
            limit=limit,
            offset=offset,
            phone=phone,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeCustomerResponse",
            '400': "KnowledgeCustomerResponse",
            '503': "KnowledgeCustomerResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_knowledge_extract_customer_get_without_preload_content(
        self,
        client_id: Optional[StrictStr] = None,
        email: Optional[StrictStr] = None,
        first_name: Optional[StrictStr] = None,
        last_name: Optional[StrictStr] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        phone: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Knowledge Customers

        Search customers by optional first/last/email/phone with prefix match (ILIKE '%') scoped to a client.

        :param client_id:
        :type client_id: str
        :param email:
        :type email: str
        :param first_name:
        :type first_name: str
        :param last_name:
        :type last_name: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param phone:
        :type phone: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_customer_get_serialize(
            client_id=client_id,
            email=email,
            first_name=first_name,
            last_name=last_name,
            limit=limit,
            offset=offset,
            phone=phone,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeCustomerResponse",
            '400': "KnowledgeCustomerResponse",
            '503': "KnowledgeCustomerResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_knowledge_extract_customer_get_serialize(
        self,
        client_id,
        email,
        first_name,
        last_name,
        limit,
        offset,
        phone,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if client_id is not None:
            
            _query_params.append(('client_id', client_id))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if first_name is not None:
            
            _query_params.append(('first_name', first_name))
            
        if last_name is not None:
            
            _query_params.append(('last_name', last_name))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if phone is not None:
            
            _query_params.append(('phone', phone))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'TokenAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/knowledge/extract/customer/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_knowledge_extract_order_get(
        self,
        billing_address_hash: Optional[StrictStr] = None,
        channel: Optional[StrictStr] = None,
        client_id: Annotated[Optional[StrictStr], Field(description="required")] = None,
        currency: Optional[StrictStr] = None,
        customer_entity_id: Optional[StrictStr] = None,
        email_at_order: Optional[StrictStr] = None,
        ext_order_id: Optional[StrictStr] = None,
        ext_order_number: Optional[StrictStr] = None,
        ext_store_id: Optional[StrictStr] = None,
        financial_status: Optional[StrictStr] = None,
        fulfillment_status: Optional[StrictStr] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        phone_at_order: Optional[StrictStr] = None,
        placed_from: Annotated[Optional[StrictStr], Field(description="raw string ISO-8601")] = None,
        placed_to: Optional[StrictStr] = None,
        shipping_address_hash: Optional[StrictStr] = None,
        source_name: Optional[StrictStr] = None,
        status: Optional[StrictStr] = None,
        store_entity_id: Optional[StrictStr] = None,
        total_max: Optional[StrictStr] = None,
        total_min: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> KnowledgeOrderResponse:
        """Get Knowledge Orders

        Query orders by optional filters (prefix ILIKE on text refs, exact match on enums, date/amount ranges) scoped to a client.

        :param billing_address_hash:
        :type billing_address_hash: str
        :param channel:
        :type channel: str
        :param client_id: required
        :type client_id: str
        :param currency:
        :type currency: str
        :param customer_entity_id:
        :type customer_entity_id: str
        :param email_at_order:
        :type email_at_order: str
        :param ext_order_id:
        :type ext_order_id: str
        :param ext_order_number:
        :type ext_order_number: str
        :param ext_store_id:
        :type ext_store_id: str
        :param financial_status:
        :type financial_status: str
        :param fulfillment_status:
        :type fulfillment_status: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param phone_at_order:
        :type phone_at_order: str
        :param placed_from: raw string ISO-8601
        :type placed_from: str
        :param placed_to:
        :type placed_to: str
        :param shipping_address_hash:
        :type shipping_address_hash: str
        :param source_name:
        :type source_name: str
        :param status:
        :type status: str
        :param store_entity_id:
        :type store_entity_id: str
        :param total_max:
        :type total_max: str
        :param total_min:
        :type total_min: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_order_get_serialize(
            billing_address_hash=billing_address_hash,
            channel=channel,
            client_id=client_id,
            currency=currency,
            customer_entity_id=customer_entity_id,
            email_at_order=email_at_order,
            ext_order_id=ext_order_id,
            ext_order_number=ext_order_number,
            ext_store_id=ext_store_id,
            financial_status=financial_status,
            fulfillment_status=fulfillment_status,
            limit=limit,
            offset=offset,
            phone_at_order=phone_at_order,
            placed_from=placed_from,
            placed_to=placed_to,
            shipping_address_hash=shipping_address_hash,
            source_name=source_name,
            status=status,
            store_entity_id=store_entity_id,
            total_max=total_max,
            total_min=total_min,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeOrderResponse",
            '400': "KnowledgeOrderResponse",
            '503': "KnowledgeOrderResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_knowledge_extract_order_get_with_http_info(
        self,
        billing_address_hash: Optional[StrictStr] = None,
        channel: Optional[StrictStr] = None,
        client_id: Annotated[Optional[StrictStr], Field(description="required")] = None,
        currency: Optional[StrictStr] = None,
        customer_entity_id: Optional[StrictStr] = None,
        email_at_order: Optional[StrictStr] = None,
        ext_order_id: Optional[StrictStr] = None,
        ext_order_number: Optional[StrictStr] = None,
        ext_store_id: Optional[StrictStr] = None,
        financial_status: Optional[StrictStr] = None,
        fulfillment_status: Optional[StrictStr] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        phone_at_order: Optional[StrictStr] = None,
        placed_from: Annotated[Optional[StrictStr], Field(description="raw string ISO-8601")] = None,
        placed_to: Optional[StrictStr] = None,
        shipping_address_hash: Optional[StrictStr] = None,
        source_name: Optional[StrictStr] = None,
        status: Optional[StrictStr] = None,
        store_entity_id: Optional[StrictStr] = None,
        total_max: Optional[StrictStr] = None,
        total_min: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[KnowledgeOrderResponse]:
        """Get Knowledge Orders

        Query orders by optional filters (prefix ILIKE on text refs, exact match on enums, date/amount ranges) scoped to a client.

        :param billing_address_hash:
        :type billing_address_hash: str
        :param channel:
        :type channel: str
        :param client_id: required
        :type client_id: str
        :param currency:
        :type currency: str
        :param customer_entity_id:
        :type customer_entity_id: str
        :param email_at_order:
        :type email_at_order: str
        :param ext_order_id:
        :type ext_order_id: str
        :param ext_order_number:
        :type ext_order_number: str
        :param ext_store_id:
        :type ext_store_id: str
        :param financial_status:
        :type financial_status: str
        :param fulfillment_status:
        :type fulfillment_status: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param phone_at_order:
        :type phone_at_order: str
        :param placed_from: raw string ISO-8601
        :type placed_from: str
        :param placed_to:
        :type placed_to: str
        :param shipping_address_hash:
        :type shipping_address_hash: str
        :param source_name:
        :type source_name: str
        :param status:
        :type status: str
        :param store_entity_id:
        :type store_entity_id: str
        :param total_max:
        :type total_max: str
        :param total_min:
        :type total_min: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_order_get_serialize(
            billing_address_hash=billing_address_hash,
            channel=channel,
            client_id=client_id,
            currency=currency,
            customer_entity_id=customer_entity_id,
            email_at_order=email_at_order,
            ext_order_id=ext_order_id,
            ext_order_number=ext_order_number,
            ext_store_id=ext_store_id,
            financial_status=financial_status,
            fulfillment_status=fulfillment_status,
            limit=limit,
            offset=offset,
            phone_at_order=phone_at_order,
            placed_from=placed_from,
            placed_to=placed_to,
            shipping_address_hash=shipping_address_hash,
            source_name=source_name,
            status=status,
            store_entity_id=store_entity_id,
            total_max=total_max,
            total_min=total_min,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeOrderResponse",
            '400': "KnowledgeOrderResponse",
            '503': "KnowledgeOrderResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_knowledge_extract_order_get_without_preload_content(
        self,
        billing_address_hash: Optional[StrictStr] = None,
        channel: Optional[StrictStr] = None,
        client_id: Annotated[Optional[StrictStr], Field(description="required")] = None,
        currency: Optional[StrictStr] = None,
        customer_entity_id: Optional[StrictStr] = None,
        email_at_order: Optional[StrictStr] = None,
        ext_order_id: Optional[StrictStr] = None,
        ext_order_number: Optional[StrictStr] = None,
        ext_store_id: Optional[StrictStr] = None,
        financial_status: Optional[StrictStr] = None,
        fulfillment_status: Optional[StrictStr] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        phone_at_order: Optional[StrictStr] = None,
        placed_from: Annotated[Optional[StrictStr], Field(description="raw string ISO-8601")] = None,
        placed_to: Optional[StrictStr] = None,
        shipping_address_hash: Optional[StrictStr] = None,
        source_name: Optional[StrictStr] = None,
        status: Optional[StrictStr] = None,
        store_entity_id: Optional[StrictStr] = None,
        total_max: Optional[StrictStr] = None,
        total_min: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Knowledge Orders

        Query orders by optional filters (prefix ILIKE on text refs, exact match on enums, date/amount ranges) scoped to a client.

        :param billing_address_hash:
        :type billing_address_hash: str
        :param channel:
        :type channel: str
        :param client_id: required
        :type client_id: str
        :param currency:
        :type currency: str
        :param customer_entity_id:
        :type customer_entity_id: str
        :param email_at_order:
        :type email_at_order: str
        :param ext_order_id:
        :type ext_order_id: str
        :param ext_order_number:
        :type ext_order_number: str
        :param ext_store_id:
        :type ext_store_id: str
        :param financial_status:
        :type financial_status: str
        :param fulfillment_status:
        :type fulfillment_status: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param phone_at_order:
        :type phone_at_order: str
        :param placed_from: raw string ISO-8601
        :type placed_from: str
        :param placed_to:
        :type placed_to: str
        :param shipping_address_hash:
        :type shipping_address_hash: str
        :param source_name:
        :type source_name: str
        :param status:
        :type status: str
        :param store_entity_id:
        :type store_entity_id: str
        :param total_max:
        :type total_max: str
        :param total_min:
        :type total_min: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_order_get_serialize(
            billing_address_hash=billing_address_hash,
            channel=channel,
            client_id=client_id,
            currency=currency,
            customer_entity_id=customer_entity_id,
            email_at_order=email_at_order,
            ext_order_id=ext_order_id,
            ext_order_number=ext_order_number,
            ext_store_id=ext_store_id,
            financial_status=financial_status,
            fulfillment_status=fulfillment_status,
            limit=limit,
            offset=offset,
            phone_at_order=phone_at_order,
            placed_from=placed_from,
            placed_to=placed_to,
            shipping_address_hash=shipping_address_hash,
            source_name=source_name,
            status=status,
            store_entity_id=store_entity_id,
            total_max=total_max,
            total_min=total_min,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeOrderResponse",
            '400': "KnowledgeOrderResponse",
            '503': "KnowledgeOrderResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_knowledge_extract_order_get_serialize(
        self,
        billing_address_hash,
        channel,
        client_id,
        currency,
        customer_entity_id,
        email_at_order,
        ext_order_id,
        ext_order_number,
        ext_store_id,
        financial_status,
        fulfillment_status,
        limit,
        offset,
        phone_at_order,
        placed_from,
        placed_to,
        shipping_address_hash,
        source_name,
        status,
        store_entity_id,
        total_max,
        total_min,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if billing_address_hash is not None:
            
            _query_params.append(('billing_address_hash', billing_address_hash))
            
        if channel is not None:
            
            _query_params.append(('channel', channel))
            
        if client_id is not None:
            
            _query_params.append(('client_id', client_id))
            
        if currency is not None:
            
            _query_params.append(('currency', currency))
            
        if customer_entity_id is not None:
            
            _query_params.append(('customer_entity_id', customer_entity_id))
            
        if email_at_order is not None:
            
            _query_params.append(('email_at_order', email_at_order))
            
        if ext_order_id is not None:
            
            _query_params.append(('ext_order_id', ext_order_id))
            
        if ext_order_number is not None:
            
            _query_params.append(('ext_order_number', ext_order_number))
            
        if ext_store_id is not None:
            
            _query_params.append(('ext_store_id', ext_store_id))
            
        if financial_status is not None:
            
            _query_params.append(('financial_status', financial_status))
            
        if fulfillment_status is not None:
            
            _query_params.append(('fulfillment_status', fulfillment_status))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if phone_at_order is not None:
            
            _query_params.append(('phone_at_order', phone_at_order))
            
        if placed_from is not None:
            
            _query_params.append(('placed_from', placed_from))
            
        if placed_to is not None:
            
            _query_params.append(('placed_to', placed_to))
            
        if shipping_address_hash is not None:
            
            _query_params.append(('shipping_address_hash', shipping_address_hash))
            
        if source_name is not None:
            
            _query_params.append(('source_name', source_name))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if store_entity_id is not None:
            
            _query_params.append(('store_entity_id', store_entity_id))
            
        if total_max is not None:
            
            _query_params.append(('total_max', total_max))
            
        if total_min is not None:
            
            _query_params.append(('total_min', total_min))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'TokenAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/knowledge/extract/order/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_knowledge_extract_product_get(
        self,
        client_id: Annotated[Optional[StrictStr], Field(description="Client ID")] = None,
        product_id: Annotated[Optional[StrictInt], Field(description="Numeric product ID (exact match)")] = None,
        handle: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        product_hash: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Default 100, max 500")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> KnowledgeProductResponse:
        """Get Knowledge Products

        Query products by optional filters (prefix ILIKE on text fields, equality on product_id) scoped to a client.

        :param client_id: Client ID
        :type client_id: str
        :param product_id: Numeric product ID (exact match)
        :type product_id: int
        :param handle: Prefix match
        :type handle: str
        :param title: Prefix match
        :type title: str
        :param type: Prefix match
        :type type: str
        :param product_hash: Prefix match
        :type product_hash: str
        :param limit: Default 100, max 500
        :type limit: int
        :param offset: Default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_product_get_serialize(
            client_id=client_id,
            product_id=product_id,
            handle=handle,
            title=title,
            type=type,
            product_hash=product_hash,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeProductResponse",
            '400': "KnowledgeProductResponse",
            '503': "KnowledgeProductResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_knowledge_extract_product_get_with_http_info(
        self,
        client_id: Annotated[Optional[StrictStr], Field(description="Client ID")] = None,
        product_id: Annotated[Optional[StrictInt], Field(description="Numeric product ID (exact match)")] = None,
        handle: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        product_hash: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Default 100, max 500")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[KnowledgeProductResponse]:
        """Get Knowledge Products

        Query products by optional filters (prefix ILIKE on text fields, equality on product_id) scoped to a client.

        :param client_id: Client ID
        :type client_id: str
        :param product_id: Numeric product ID (exact match)
        :type product_id: int
        :param handle: Prefix match
        :type handle: str
        :param title: Prefix match
        :type title: str
        :param type: Prefix match
        :type type: str
        :param product_hash: Prefix match
        :type product_hash: str
        :param limit: Default 100, max 500
        :type limit: int
        :param offset: Default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_product_get_serialize(
            client_id=client_id,
            product_id=product_id,
            handle=handle,
            title=title,
            type=type,
            product_hash=product_hash,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeProductResponse",
            '400': "KnowledgeProductResponse",
            '503': "KnowledgeProductResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_knowledge_extract_product_get_without_preload_content(
        self,
        client_id: Annotated[Optional[StrictStr], Field(description="Client ID")] = None,
        product_id: Annotated[Optional[StrictInt], Field(description="Numeric product ID (exact match)")] = None,
        handle: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        type: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        product_hash: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Default 100, max 500")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Knowledge Products

        Query products by optional filters (prefix ILIKE on text fields, equality on product_id) scoped to a client.

        :param client_id: Client ID
        :type client_id: str
        :param product_id: Numeric product ID (exact match)
        :type product_id: int
        :param handle: Prefix match
        :type handle: str
        :param title: Prefix match
        :type title: str
        :param type: Prefix match
        :type type: str
        :param product_hash: Prefix match
        :type product_hash: str
        :param limit: Default 100, max 500
        :type limit: int
        :param offset: Default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_product_get_serialize(
            client_id=client_id,
            product_id=product_id,
            handle=handle,
            title=title,
            type=type,
            product_hash=product_hash,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeProductResponse",
            '400': "KnowledgeProductResponse",
            '503': "KnowledgeProductResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_knowledge_extract_product_get_serialize(
        self,
        client_id,
        product_id,
        handle,
        title,
        type,
        product_hash,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if client_id is not None:
            
            _query_params.append(('clientId', client_id))
            
        if product_id is not None:
            
            _query_params.append(('productId', product_id))
            
        if handle is not None:
            
            _query_params.append(('handle', handle))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if type is not None:
            
            _query_params.append(('type', type))
            
        if product_hash is not None:
            
            _query_params.append(('productHash', product_hash))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'TokenAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/knowledge/extract/product/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_knowledge_extract_store_get(
        self,
        client_id: Annotated[StrictStr, Field(description="Client ID (required)")],
        entity_id: Annotated[Optional[StrictStr], Field(description="Exact match on entity_id")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        domain: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Default 100, max 500")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> KnowledgeStoreResponse:
        """Get Knowledge Stores

        Query stores by optional filters (prefix ILIKE on name/domain/title; exact match on entity_id) scoped to a client.

        :param client_id: Client ID (required) (required)
        :type client_id: str
        :param entity_id: Exact match on entity_id
        :type entity_id: str
        :param name: Prefix match
        :type name: str
        :param domain: Prefix match
        :type domain: str
        :param title: Prefix match
        :type title: str
        :param limit: Default 100, max 500
        :type limit: int
        :param offset: Default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_store_get_serialize(
            client_id=client_id,
            entity_id=entity_id,
            name=name,
            domain=domain,
            title=title,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeStoreResponse",
            '400': "KnowledgeStoreResponse",
            '503': "KnowledgeStoreResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_knowledge_extract_store_get_with_http_info(
        self,
        client_id: Annotated[StrictStr, Field(description="Client ID (required)")],
        entity_id: Annotated[Optional[StrictStr], Field(description="Exact match on entity_id")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        domain: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Default 100, max 500")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[KnowledgeStoreResponse]:
        """Get Knowledge Stores

        Query stores by optional filters (prefix ILIKE on name/domain/title; exact match on entity_id) scoped to a client.

        :param client_id: Client ID (required) (required)
        :type client_id: str
        :param entity_id: Exact match on entity_id
        :type entity_id: str
        :param name: Prefix match
        :type name: str
        :param domain: Prefix match
        :type domain: str
        :param title: Prefix match
        :type title: str
        :param limit: Default 100, max 500
        :type limit: int
        :param offset: Default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_store_get_serialize(
            client_id=client_id,
            entity_id=entity_id,
            name=name,
            domain=domain,
            title=title,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeStoreResponse",
            '400': "KnowledgeStoreResponse",
            '503': "KnowledgeStoreResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_knowledge_extract_store_get_without_preload_content(
        self,
        client_id: Annotated[StrictStr, Field(description="Client ID (required)")],
        entity_id: Annotated[Optional[StrictStr], Field(description="Exact match on entity_id")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        domain: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Prefix match")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Default 100, max 500")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Default 0")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Knowledge Stores

        Query stores by optional filters (prefix ILIKE on name/domain/title; exact match on entity_id) scoped to a client.

        :param client_id: Client ID (required) (required)
        :type client_id: str
        :param entity_id: Exact match on entity_id
        :type entity_id: str
        :param name: Prefix match
        :type name: str
        :param domain: Prefix match
        :type domain: str
        :param title: Prefix match
        :type title: str
        :param limit: Default 100, max 500
        :type limit: int
        :param offset: Default 0
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_knowledge_extract_store_get_serialize(
            client_id=client_id,
            entity_id=entity_id,
            name=name,
            domain=domain,
            title=title,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "KnowledgeStoreResponse",
            '400': "KnowledgeStoreResponse",
            '503': "KnowledgeStoreResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_knowledge_extract_store_get_serialize(
        self,
        client_id,
        entity_id,
        name,
        domain,
        title,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if client_id is not None:
            
            _query_params.append(('clientId', client_id))
            
        if entity_id is not None:
            
            _query_params.append(('entityId', entity_id))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if domain is not None:
            
            _query_params.append(('domain', domain))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'TokenAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/knowledge/extract/store/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


