"""
Auto-generated cassette tests for Github connector.

These tests are generated from cassette YAML files and test the connector
against recorded API responses.
"""

import pytest
from unittest.mock import AsyncMock, patch

from airbyte_ai_github import GithubConnector


@pytest.mark.asyncio
async def test_repositories_get():
    """Captured from real API call on 2025-12-01"""
    mock_response = {'data': {'repository': {'id': 'MDEwOlJlcG9zaXRvcnkxMjk2MjY5', 'name': 'Hello-World', 'nameWithOwner': 'octocat/Hello-World', 'description': 'My first repository on GitHub!', 'url': 'https://github.com/octocat/Hello-World', 'createdAt': '2011-01-26T19:01:12Z', 'updatedAt': '2025-12-01T12:37:07Z', 'pushedAt': '2024-08-20T23:54:42Z', 'forkCount': 8035, 'stargazerCount': 3310, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': True, 'hasWikiEnabled': True, 'primaryLanguage': None, 'licenseInfo': None, 'owner': {'login': 'octocat', 'avatarUrl': 'https://avatars.githubusercontent.com/u/583231?u=a59fef2a493e2b67dd13754231daf220c82ba84d&v=4'}, 'defaultBranchRef': {'name': 'master'}, 'repositoryTopics': {'nodes': []}}}}

    connector = GithubConnector(auth_config={"access_token": "test_key"})

    with patch(
        "airbyte_ai_github._vendored.connector_sdk.http_client.HTTPClient.request",
        new=AsyncMock(return_value=mock_response)
    ):
        result = await connector.repositories.get(owner="octocat", repo="Hello-World")

    assert result == mock_response

@pytest.mark.asyncio
async def test_repositories_list():
    """Captured from real API call on 2025-12-01"""
    mock_response = {'data': {'user': {'repositories': {'nodes': [{'id': 'MDEwOlJlcG9zaXRvcnkxMjk2MjY5', 'name': 'Hello-World', 'nameWithOwner': 'octocat/Hello-World', 'description': 'My first repository on GitHub!', 'url': 'https://github.com/octocat/Hello-World', 'createdAt': '2011-01-26T19:01:12Z', 'updatedAt': '2025-12-01T12:37:07Z', 'pushedAt': '2024-08-20T23:54:42Z', 'forkCount': 8035, 'stargazerCount': 3310, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': True, 'hasWikiEnabled': True, 'primaryLanguage': None, 'licenseInfo': None, 'owner': {'login': 'octocat', 'avatarUrl': 'https://avatars.githubusercontent.com/u/583231?u=a59fef2a493e2b67dd13754231daf220c82ba84d&v=4'}, 'defaultBranchRef': {'name': 'master'}, 'repositoryTopics': {'nodes': []}}, {'id': 'MDEwOlJlcG9zaXRvcnkxMzAwMTky', 'name': 'Spoon-Knife', 'nameWithOwner': 'octocat/Spoon-Knife', 'description': 'This repo is for demonstration purposes only.', 'url': 'https://github.com/octocat/Spoon-Knife', 'createdAt': '2011-01-27T19:30:43Z', 'updatedAt': '2025-12-02T01:46:16Z', 'pushedAt': '2024-08-21T15:25:42Z', 'forkCount': 154876, 'stargazerCount': 13427, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': True, 'hasWikiEnabled': True, 'primaryLanguage': {'name': 'HTML'}, 'licenseInfo': None, 'owner': {'login': 'octocat', 'avatarUrl': 'https://avatars.githubusercontent.com/u/583231?u=a59fef2a493e2b67dd13754231daf220c82ba84d&v=4'}, 'defaultBranchRef': {'name': 'main'}, 'repositoryTopics': {'nodes': []}}, {'id': 'MDEwOlJlcG9zaXRvcnkxMjMyNTQ4OA==', 'name': 'download', 'nameWithOwner': 'kevva/download', 'description': 'Download and extract files', 'url': 'https://github.com/kevva/download', 'createdAt': '2013-08-23T14:49:56Z', 'updatedAt': '2025-11-26T05:48:44Z', 'pushedAt': '2023-10-08T19:06:13Z', 'forkCount': 202, 'stargazerCount': 1300, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': True, 'hasWikiEnabled': True, 'primaryLanguage': {'name': 'JavaScript'}, 'licenseInfo': {'name': 'MIT License', 'spdxId': 'MIT'}, 'owner': {'login': 'kevva', 'avatarUrl': 'https://avatars.githubusercontent.com/u/709159?u=5c9a37233feea1a66d2efd961227c481312adb3d&v=4'}, 'defaultBranchRef': {'name': 'master'}, 'repositoryTopics': {'nodes': [{'topic': {'name': 'http'}}, {'topic': {'name': 'promise'}}, {'topic': {'name': 'async'}}, {'topic': {'name': 'download'}}, {'topic': {'name': 'extract'}}, {'topic': {'name': 'decompress'}}, {'topic': {'name': 'stream'}}, {'topic': {'name': 'nodejs'}}]}}, {'id': 'MDEwOlJlcG9zaXRvcnkxMjMyNTU0NA==', 'name': 'decompress', 'nameWithOwner': 'kevva/decompress', 'description': 'Extracting archives made easy', 'url': 'https://github.com/kevva/decompress', 'createdAt': '2013-08-23T14:52:29Z', 'updatedAt': '2025-12-02T00:54:22Z', 'pushedAt': '2023-01-06T19:01:33Z', 'forkCount': 51, 'stargazerCount': 417, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': True, 'hasWikiEnabled': True, 'primaryLanguage': {'name': 'JavaScript'}, 'licenseInfo': {'name': 'MIT License', 'spdxId': 'MIT'}, 'owner': {'login': 'kevva', 'avatarUrl': 'https://avatars.githubusercontent.com/u/709159?u=5c9a37233feea1a66d2efd961227c481312adb3d&v=4'}, 'defaultBranchRef': {'name': 'master'}, 'repositoryTopics': {'nodes': [{'topic': {'name': 'extract'}}, {'topic': {'name': 'decompress'}}, {'topic': {'name': 'zip'}}, {'topic': {'name': 'tar'}}, {'topic': {'name': 'targz'}}, {'topic': {'name': 'nodejs'}}]}}, {'id': 'MDEwOlJlcG9zaXRvcnkxMjQxNDA4Mg==', 'name': 'bin-wrapper', 'nameWithOwner': 'kevva/bin-wrapper', 'description': 'Binary wrapper that makes your programs seamlessly available as local dependencies', 'url': 'https://github.com/kevva/bin-wrapper', 'createdAt': '2013-08-27T18:25:42Z', 'updatedAt': '2025-11-13T08:25:00Z', 'pushedAt': '2024-04-18T13:05:44Z', 'forkCount': 66, 'stargazerCount': 154, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': True, 'hasWikiEnabled': True, 'primaryLanguage': {'name': 'JavaScript'}, 'licenseInfo': {'name': 'MIT License', 'spdxId': 'MIT'}, 'owner': {'login': 'kevva', 'avatarUrl': 'https://avatars.githubusercontent.com/u/709159?u=5c9a37233feea1a66d2efd961227c481312adb3d&v=4'}, 'defaultBranchRef': {'name': 'master'}, 'repositoryTopics': {'nodes': []}}]}}}}

    connector = GithubConnector(auth_config={"access_token": "test_key"})

    with patch(
        "airbyte_ai_github._vendored.connector_sdk.http_client.HTTPClient.request",
        new=AsyncMock(return_value=mock_response)
    ):
        result = await connector.repositories.list(username="octocat", per_page=5)

    assert result == mock_response

@pytest.mark.asyncio
async def test_repositories_search():
    """Captured from real API call on 2025-12-01"""
    mock_response = {'data': {'search': {'repositoryCount': 767, 'nodes': [{'id': 'MDEwOlJlcG9zaXRvcnk1NDM0Njc5OQ==', 'name': 'public-apis', 'nameWithOwner': 'public-apis/public-apis', 'description': 'A collective list of free APIs', 'url': 'https://github.com/public-apis/public-apis', 'createdAt': '2016-03-20T23:49:42Z', 'updatedAt': '2025-12-02T05:30:40Z', 'pushedAt': '2025-11-04T18:29:01Z', 'forkCount': 40742, 'stargazerCount': 382201, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': True, 'hasWikiEnabled': False, 'primaryLanguage': {'name': 'Python'}, 'licenseInfo': {'name': 'MIT License', 'spdxId': 'MIT'}, 'owner': {'login': 'public-apis', 'avatarUrl': 'https://avatars.githubusercontent.com/u/51121562?v=4'}, 'defaultBranchRef': {'name': 'master'}, 'repositoryTopics': {'nodes': [{'topic': {'name': 'api'}}, {'topic': {'name': 'public-apis'}}, {'topic': {'name': 'free'}}, {'topic': {'name': 'apis'}}, {'topic': {'name': 'list'}}, {'topic': {'name': 'development'}}, {'topic': {'name': 'software'}}, {'topic': {'name': 'public'}}, {'topic': {'name': 'resources'}}, {'topic': {'name': 'dataset'}}]}}, {'id': 'MDEwOlJlcG9zaXRvcnkxMzQ5MTg5NQ==', 'name': 'free-programming-books', 'nameWithOwner': 'EbookFoundation/free-programming-books', 'description': ':books: Freely available programming books', 'url': 'https://github.com/EbookFoundation/free-programming-books', 'createdAt': '2013-10-11T06:50:37Z', 'updatedAt': '2025-12-02T05:08:16Z', 'pushedAt': '2025-11-28T14:23:46Z', 'forkCount': 65586, 'stargazerCount': 378080, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': True, 'hasWikiEnabled': False, 'primaryLanguage': {'name': 'Python'}, 'licenseInfo': {'name': 'Creative Commons Attribution 4.0 International', 'spdxId': 'CC-BY-4.0'}, 'owner': {'login': 'EbookFoundation', 'avatarUrl': 'https://avatars.githubusercontent.com/u/14127308?v=4'}, 'defaultBranchRef': {'name': 'main'}, 'repositoryTopics': {'nodes': [{'topic': {'name': 'education'}}, {'topic': {'name': 'books'}}, {'topic': {'name': 'list'}}, {'topic': {'name': 'resource'}}, {'topic': {'name': 'hacktoberfest'}}]}}, {'id': 'MDEwOlJlcG9zaXRvcnk4MzIyMjQ0MQ==', 'name': 'system-design-primer', 'nameWithOwner': 'donnemartin/system-design-primer', 'description': 'Learn how to design large-scale systems. Prep for the system design interview.  Includes Anki flashcards.', 'url': 'https://github.com/donnemartin/system-design-primer', 'createdAt': '2017-02-26T16:15:28Z', 'updatedAt': '2025-12-02T05:17:59Z', 'pushedAt': '2025-11-03T12:06:22Z', 'forkCount': 53510, 'stargazerCount': 328208, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': True, 'hasWikiEnabled': True, 'primaryLanguage': {'name': 'Python'}, 'licenseInfo': {'name': 'Other', 'spdxId': 'NOASSERTION'}, 'owner': {'login': 'donnemartin', 'avatarUrl': 'https://avatars.githubusercontent.com/u/5458997?u=f1007b583e55e7ccfb6ccf0e200051156112dd9b&v=4'}, 'defaultBranchRef': {'name': 'master'}, 'repositoryTopics': {'nodes': [{'topic': {'name': 'programming'}}, {'topic': {'name': 'development'}}, {'topic': {'name': 'design'}}, {'topic': {'name': 'design-system'}}, {'topic': {'name': 'system'}}, {'topic': {'name': 'design-patterns'}}, {'topic': {'name': 'web'}}, {'topic': {'name': 'web-application'}}, {'topic': {'name': 'webapp'}}, {'topic': {'name': 'python'}}]}}, {'id': 'MDEwOlJlcG9zaXRvcnkyMTI4OTExMA==', 'name': 'awesome-python', 'nameWithOwner': 'vinta/awesome-python', 'description': 'An opinionated list of awesome Python frameworks, libraries, software and resources.', 'url': 'https://github.com/vinta/awesome-python', 'createdAt': '2014-06-27T21:00:06Z', 'updatedAt': '2025-12-02T05:40:39Z', 'pushedAt': '2025-11-20T09:45:51Z', 'forkCount': 26845, 'stargazerCount': 272053, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': False, 'hasWikiEnabled': False, 'primaryLanguage': {'name': 'Python'}, 'licenseInfo': {'name': 'Other', 'spdxId': 'NOASSERTION'}, 'owner': {'login': 'vinta', 'avatarUrl': 'https://avatars.githubusercontent.com/u/652070?u=25dca0371a54b997c61ed58fcdd2398d4958d1f3&v=4'}, 'defaultBranchRef': {'name': 'master'}, 'repositoryTopics': {'nodes': [{'topic': {'name': 'awesome'}}, {'topic': {'name': 'python'}}, {'topic': {'name': 'collections'}}, {'topic': {'name': 'python-library'}}, {'topic': {'name': 'python-framework'}}, {'topic': {'name': 'python-resources'}}]}}, {'id': 'MDEwOlJlcG9zaXRvcnk2MzQ3NjMzNw==', 'name': 'Python', 'nameWithOwner': 'TheAlgorithms/Python', 'description': 'All Algorithms implemented in Python', 'url': 'https://github.com/TheAlgorithms/Python', 'createdAt': '2016-07-16T09:44:01Z', 'updatedAt': '2025-12-02T05:33:48Z', 'pushedAt': '2025-12-01T21:08:50Z', 'forkCount': 49466, 'stargazerCount': 213988, 'isPrivate': False, 'isFork': False, 'isArchived': False, 'isTemplate': False, 'hasIssuesEnabled': True, 'hasWikiEnabled': True, 'primaryLanguage': {'name': 'Python'}, 'licenseInfo': {'name': 'MIT License', 'spdxId': 'MIT'}, 'owner': {'login': 'TheAlgorithms', 'avatarUrl': 'https://avatars.githubusercontent.com/u/20487725?v=4'}, 'defaultBranchRef': {'name': 'master'}, 'repositoryTopics': {'nodes': [{'topic': {'name': 'python'}}, {'topic': {'name': 'algorithm'}}, {'topic': {'name': 'algorithms-implemented'}}, {'topic': {'name': 'algorithm-competitions'}}, {'topic': {'name': 'algos'}}, {'topic': {'name': 'sorts'}}, {'topic': {'name': 'searches'}}, {'topic': {'name': 'sorting-algorithms'}}, {'topic': {'name': 'education'}}, {'topic': {'name': 'learn'}}]}}]}}}

    connector = GithubConnector(auth_config={"access_token": "test_key"})

    with patch(
        "airbyte_ai_github._vendored.connector_sdk.http_client.HTTPClient.request",
        new=AsyncMock(return_value=mock_response)
    ):
        result = await connector.repositories.search(query="language:python stars:>10000", limit=5)

    assert result == mock_response
