import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IClientVpnEndpoint } from './client-vpn-endpoint-types';
/**
 * Options for a ClientVpnAuthorizationRule.
 *
 * @stability stable
 */
export interface ClientVpnAuthorizationRuleOptions {
    /**
     * The IPv4 address range, in CIDR notation, of the network for which access is being authorized.
     *
     * @stability stable
     */
    readonly cidr: string;
    /**
     * The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group.
     *
     * @default - authorize all groups
     * @stability stable
     */
    readonly groupId?: string;
    /**
     * A brief description of the authorization rule.
     *
     * @default - no description
     * @stability stable
     */
    readonly description?: string;
}
/**
 * Properties for a ClientVpnAuthorizationRule.
 *
 * @stability stable
 */
export interface ClientVpnAuthorizationRuleProps extends ClientVpnAuthorizationRuleOptions {
    /**
     * The client VPN endpoint to which to add the rule.
     *
     * @default clientVpnEndpoint is required
     * @stability stable
     */
    readonly clientVpnEndpoint?: IClientVpnEndpoint;
    /**
     * (deprecated) The client VPN endpoint to which to add the rule.
     *
     * @default clientVpnEndpoint is required
     * @deprecated Use `clientVpnEndpoint` instead
     */
    readonly clientVpnEndoint?: IClientVpnEndpoint;
}
/**
 * A client VPN authorization rule.
 *
 * @stability stable
 */
export declare class ClientVpnAuthorizationRule extends Resource {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ClientVpnAuthorizationRuleProps);
}
