# Generated by Django 2.2.13 on 2020-11-24 15:52

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('NEMO', '0024_contactinformation_user'),
    ]

    operations = [
        migrations.CreateModel(
            name='ToolUsageCounter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name of this counter', max_length=200)),
                ('description', models.TextField(blank=True, help_text='The counter description to be displayed next to it on the tool control page', null=True)),
                ('value', models.PositiveIntegerField(default=0, help_text='The current value of this counter')),
                ('tool_usage_question', models.CharField(help_text="The name of the tool's post usage question which should be used to increment this counter", max_length=200)),
                ('last_reset_value', models.PositiveIntegerField(blank=True, help_text='The last value before the counter was reset', null=True)),
                ('last_reset', models.DateTimeField(blank=True, help_text='The date and time this counter was last reset', null=True)),
                ('is_active', models.BooleanField(default=True, help_text='The state of the counter')),
                ('last_reset_by', models.ForeignKey(blank=True, help_text='The user who last reset this counter', null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('tool', models.ForeignKey(help_text='The tool this counter is for.', on_delete=django.db.models.deletion.CASCADE, to='NEMO.Tool')),
            ],
        ),
        migrations.CreateModel(
            name='PhysicalAccessException',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name of this exception that will be displayed as the policy problem', max_length=100)),
                ('start_time', models.DateTimeField(help_text='The start of the exception, after which users will be denied access.')),
                ('end_time', models.DateTimeField(help_text='The end of the exception, after which users will be allowed access again')),
                ('physical_access_levels', models.ManyToManyField(blank=True, to='NEMO.PhysicalAccessLevel')),
            ],
            options={
                'ordering': ['-start_time'],
            },
        ),
    ]
