"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongControlPlaneECS = void 0;
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const secretManager = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("constructs");
// import { KongControlPlane } from '../KongControlPlane';
const kong_admin_service_1 = require("./kong-admin-service");
const kong_admin_taskdefinition_1 = require("./kong-admin-taskdefinition");
class KongControlPlaneECS extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let secrets = {};
        if (props.rds.secret) {
            secrets.KONG_PG_USERNAME = aws_ecs_1.Secret.fromSecretsManager(props.rds.secret, 'username');
            secrets.KONG_PG_PASSWORD = aws_ecs_1.Secret.fromSecretsManager(props.rds.secret, 'password');
            if (props.licenseSecret) {
                const licenseSecret = secretManager.Secret.fromSecretNameV2(this, 'KongCPLicense', props.licenseSecret ?? '');
                secrets.KONG_LICENSE_DATA = aws_ecs_1.Secret.fromSecretsManager(licenseSecret, 'license');
            }
        }
        const kongAdminTaskDefinition = new kong_admin_taskdefinition_1.KongAdminTaskdefinition(this, 'KongCPTaskDefinition', {
            hostedZoneName: props.route53_zone.zoneName,
            image: props.image,
            dbInstanceEndpointAddress: props.rds.dbInstanceEndpointAddress,
            dbInstanceEndpointPort: props.rds.dbInstanceEndpointPort,
            secrets: secrets,
            cluster: props.cluster,
            certificates: props.certificates,
            kongFeaturesProps: props.kongFeaturesProps,
            kongTaskProps: props.kongTaskProps,
        });
        new kong_admin_service_1.KongAdminService(this, 'KongCPFargateService', {
            kongServiceProps: {
                cluster: props.cluster,
                taskDefinition: kongAdminTaskDefinition,
                desiredCount: props.desiredCount,
            },
            adminNlb: props.adminNlb,
            managerNlb: props.managerNlb,
            devPortalNlb: props.devPortalNlb,
            kongFeaturesProps: props.kongFeaturesProps,
            route53_zone: props.route53_zone,
        });
    }
}
exports.KongControlPlaneECS = KongControlPlaneECS;
//# sourceMappingURL=data:application/json;base64,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