"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
const index_1 = require("./resources/eks/helm-charts/kong/index");
class KongEks extends constructs_1.Construct {
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        this.clusterDns = `cluster.${props.hostedZoneName}:8005`;
        this.telemetryDns = `telemetry.${props.hostedZoneName}:8006`;
        const control_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'CPSecretsKey', {
            enableKeyRotation: true,
        });
        this.controlPlane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps.eksClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
        });
        this.controlPlane.vpc.addFlowLog('CpVpcFlowLog');
        const cp_nodegroup = this.controlPlane.addNodegroupCapacity('CpASG', props.controlPlaneNodeProps);
        cp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        // });
        new kong_core.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        const kong_rds_instance = new kong_core.RdsStack(this, 'KongRds', {
            ...props.rdsProps,
            vpc: this.controlPlane.vpc,
        });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: 'kube-system',
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: this.controlPlane,
        });
        new kong_core.ExternalDns(kong_pre_requisites_nested_stack, 'ExtDns', {
            cluster: this.controlPlane,
        });
        const aws_acm_pca = new kong_core.AcmPca(kong_pre_requisites_nested_stack, 'KongCpCa', {
            hostedZoneName: props.hostedZoneName,
            vpc: this.controlPlane.vpc,
        });
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'KongCpCertManager', {
            cluster: this.controlPlane,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            privateCaArn: aws_acm_pca.privateCaArn,
        });
        this.privateCaArn = aws_acm_pca.privateCaArn;
        const kong_control_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongCpNestedStack');
        new index_1.KongControlPlaneEKS(kong_control_plane_nested_stack, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            // nodegroup: cp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-cp.internal',
            HelmOptions: props.controlPlaneClusterProps.kongHelmOptions,
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
        });
        kong_control_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack, kong_rds_instance);
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryNestedStack');
        const telemetry_stack = new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.controlPlaneClusterProps.kongTelemetryOptions.createPrometheusWorkspace,
            cluster: this.controlPlane,
            namespace: kong_core.Namespace.TELEMETRY,
            cacertname: kong_core.Tls.ADOT_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
            hostedZoneName: props.hostedZoneName,
        });
        this.prometheusEndpoint = telemetry_stack.prometheusEndpoint;
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "3.0.0-dev.1" };
//# sourceMappingURL=data:application/json;base64,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