"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEcs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ecs = require("aws-cdk-lib/aws-ecs");
// import { PostgresEngineVersion } from 'aws-cdk-lib/aws-rds';
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
//import * as kong_core from 'kong-core';
// import { RdsDatabaseProps } from './kong-eks';
const index_1 = require("./resources/ecs/index");
class KongEcs extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        //Create the Kong CP ECS Cluster
        const cluster = new ecs.Cluster(this, 'KongCPCluster', props.clusterProps);
        this.controlPlane = cluster;
        //Create the RDS Instance for KongCP
        const rds = new kong_core.RdsStack(this, 'KongCPRds', {
            ...props.rdsProps,
            vpc: this.controlPlane.vpc,
        });
        //Create the NLB for KongCP Admin
        const nlbAdmin = new kong_core.NlbStack(this, 'KongCPAlb', {
            vpc: this.controlPlane.vpc,
            name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_ADMIN_LB_SUFFIX,
            internetFacing: props.internetFacing ?? false,
        });
        //Create the NLB for KongCP Manager
        let nlbManager;
        if (props.kongFeaturesProps.kongManagerProps.enabled) {
            nlbManager = new kong_core.NlbStack(this, 'KongCPManagerAlb', {
                vpc: this.controlPlane.vpc,
                name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_MANAGER_LB_SUFFIX,
                internetFacing: props.internetFacing ?? false,
            });
        }
        //Create the NLB for KongCP DevPortal
        let nlbDevPortal;
        if (props.kongFeaturesProps.devPortalProps.enabled) {
            nlbDevPortal = new kong_core.NlbStack(this, 'KongCPDevPortalAlb', {
                vpc: this.controlPlane.vpc,
                name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_DEVPORTAL_LB_SUFFIX,
                internetFacing: props.internetFacing ?? false,
            });
        }
        const tld = props.hostedZoneName;
        const private_ca = new kong_core.AcmPca(this, 'KongPCA', {
            vpc: cluster.vpc,
            hostedZoneName: tld,
        });
        this.privateCaArn = private_ca.privateCaArn;
        this.clusterDns = 'cluster.' + tld + ':' + (props.kongFeaturesProps.clusterProps.port ?? 8005);
        this.telemetryDns = 'telemetry.' + tld + ':' + (props.kongFeaturesProps.clusterTelemetryProps.port ?? 8006);
        const kongCPCertificates = new kong_core.Certificates(this, 'KongCPCertificate', {
            topLevelDomain: tld,
            privateCaArn: private_ca.privateCaArn,
            dnsNames: [
                tld,
                'admin.' + tld,
                'cluster.' + tld,
                'telemetry.' + tld,
                'manager.' + tld,
            ],
        });
        kongCPCertificates.node.addDependency(private_ca);
        new index_1.KongControlPlaneECS(this, 'KongCP', {
            cluster: cluster,
            rds: rds.kongPostgresSql,
            adminNlb: nlbAdmin.kongNlb,
            managerNlb: nlbManager ? nlbManager.kongNlb : undefined,
            devPortalNlb: nlbDevPortal ? nlbDevPortal.kongNlb : undefined,
            image: props.image ?? 'docker.io/kong/kong-gateway:2.8.1.0-alpine',
            licenseSecret: props.licenseSecret ?? undefined,
            kongFeaturesProps: {
                adminProps: {
                    httpPort: props.kongFeaturesProps.adminProps.httpPort ?? 8001,
                    httpsPort: props.kongFeaturesProps.adminProps.httpsPort ?? 8444,
                    enableHttp: props.kongFeaturesProps.adminProps.enableHttp ?? true,
                },
                kongManagerProps: {
                    enabled: props.kongFeaturesProps.kongManagerProps.enabled ?? true,
                    enableHttp: props.kongFeaturesProps.kongManagerProps.enableHttp ?? true,
                    httpPort: props.kongFeaturesProps.kongManagerProps.httpPort ?? 8002,
                    httpsPort: props.kongFeaturesProps.kongManagerProps.httpsPort ?? 8445,
                },
                devPortalProps: {
                    enabled: props.kongFeaturesProps.devPortalProps.enabled ?? true,
                },
                clusterProps: {
                    enabled: props.kongFeaturesProps.clusterProps.enabled ?? true,
                    port: props.kongFeaturesProps.clusterProps.port ?? 8005,
                },
                clusterTelemetryProps: {
                    enabled: props.kongFeaturesProps.clusterTelemetryProps.enabled ?? true,
                    port: props.kongFeaturesProps.clusterTelemetryProps.port ?? 8006,
                },
                kongBootstrapMigration: props.kongFeaturesProps.kongBootstrapMigration ?? true,
            },
            kongTaskProps: props.kongTaskProps,
            certificates: kongCPCertificates,
            route53_zone: private_ca.route53Zone,
            desiredCount: props.desiredCount,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'KongAdminLBDNSName', {
            value: nlbAdmin.kongNlb.loadBalancerDnsName,
            exportName: 'KongAdminLBDNSName',
        });
        if (nlbManager) {
            new aws_cdk_lib_1.CfnOutput(this, 'KongManagerLBBDNSName', {
                value: nlbManager.kongNlb.loadBalancerDnsName,
                exportName: 'KongManagerLBBDNSName',
            });
        }
        if (nlbDevPortal) {
            new aws_cdk_lib_1.CfnOutput(this, 'KongDevPortalLBBDNSName', {
                value: nlbDevPortal.kongNlb.loadBalancerDnsName,
                exportName: 'KongDevPortalLBBDNSName',
            });
        }
    }
}
exports.KongEcs = KongEcs;
_a = JSII_RTTI_SYMBOL_1;
KongEcs[_a] = { fqn: "kong-control-plane.KongEcs", version: "3.0.0-dev.1" };
//# sourceMappingURL=data:application/json;base64,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