# Getting numbers out of Cytosim using `report`

You can extract formatted data from Cytosim in two different ways:

- by using the `report` command in the configuration file.
- by running the `report` executable on the trajectory file.

Both methods produce nearly identical formatted text output with selected data,
such as the coordinates of the filaments, their state or length, etc.
 
# The `report` command

The command `report` can be called from the config file.
The report will be generated by `sim` in the course of the simulation, but will be ignored by `play`.
The output can be sent to specific files of your choice, for example `forces.txt` and `positions.txt`:

	repeat 100
	{
		run 100 system
		{
		    nb_frames = 100
		}
		report fiber:force forces.txt
		report solid:position positions.txt
	}

A `star` sends the reports to the terminal:
	
	report single:force *
	report fiber:force *


# The `report` executable

If the simulation is already completed, you can use a separate executable called `report` to analyse the results. In this case `report` will read [cytosim's output files](../main/file_types.md), and is limited to the frames that have been saved.

It is important to use a `report` made with the same settings as `sim`, in particular the dimensionality `DIM` defined in `dim.h` should be the same.
To compile `report`:

	make report
	
Invoke the `report` executable from the command line:

	report fiber:force

This will analyse all the frames in the trajectory file, and send the output to the terminal. 
Example output:
	
	% frame   10
	% time    25
	% identity      posX      posY    forceX    forceY   tension
	% fiber f1:0001
	         1    -4.142    -2.815     1.366    0.9282    -1.061
	         1    -3.796   -0.8463         0         0   -0.8617
	         1    -3.061     1.006         0         0   -0.7094
	         1   -0.8413     2.949         0         0   -0.6838
	         1     1.108     3.346         0         0   -0.8099
	         1     3.093     3.136         0         0    -1.004
	         1     4.069      2.92     -1.36    -0.976         0


It is possible to redirect the output to a file in UNIX:

	report fiber:points > fiber_points.txt

You can also restrict reporting to a particular frame:

	report fiber:points frame=10 > fiber_points.txt

or to some selected frames:

	report fiber:points frame=10,20,30 > fiber_points.txt

For more info, please check:

	report help
 
# The `framewise report` executable

The executable `reportF` is similar to `report`, excepts that it sends the report of each frame into a different file. Hence,

	reportF fiber:points

will create multiple files:

	report0000.txt
	report0001.txt
	report0002.txt
	report0003.txt
	...


# What can be reported?

There are many options to `report` and the list below may not be accurate. 
Please, try them out to see what information you can obtain.
It is relatively easy to extend the report functions, declared in `src/sim/simul.h` and defined in `src/sim/simul_report.cc` to output something specific for a project. 


 WHAT            | Output
 ----------------|--------------------------------------------------------------
 `bead`          | Position of beads
 `couple`        | Summary with number of couples in each state
 `fiber`         | Length and position of the ends of fibers
 `single`        | Number and state of singles
 `solid`         | Position of center and first point of solids
 `sphere`        | Position of center and first point of spheres
 `organizer`     | Position of the center of asters and other organizers
 `field`         | Total quantity of substance in field and Lattices
 `time`          | Time
 `inventory`     | summary list of objects
 `property`      | All object properties
 `parameter`     | All object properties
 
 WHAT                    | Output
 ------------------------|------------------------------------------------------
 `fiber:position`        | Position and orientation of fibers
 `fiber:age`             | Average age of fibers
 `fiber:length`          | Average length and standard deviation of fibers
 `fiber:distribution`    | length distribution of fiber lengths (option: `max` and `interval`)
 `fiber:dynamic`         | Number of fiber classified by PLUS_END Dynamic state
 `fiber:point`           | coordinates of vertices of all fibers
 `fiber:displacement`    | mean squared displacement of fibers since the last call
 `fiber:moments`         | standard deviation of vertices of all fibers
 `fiber:speckle`         | coordinates of points randomly distributed along all fibers (option: `interval`)
 `fiber:sample`          | coordinates of points newly distributed along all fibers (option: `interval`)
 `fiber:segment`         | information about lengths of segments, number of kinks
 `fiber:end`             | Positions and dynamic states of all fiber ends
 `fiber:force`           | Position of vertices and Forces acting on vertices
 `fiber:confine_force`  | Position of vertices and Forces acting on vertices
`fiber:tension`         | Internal stress along fibers
 `fiber:energy`          | Fiber's elastic bending energy
 `fiber:confine_force`   | Position of vertices and confinement forces acting on vertices
 `fiber:confinement`     | Sum of force applied by fibers on their confinement Space
 `fiber:binder`          | Positions of bridging hands along each fiber
 `fiber:lattice`         | Total quantity on fiber's lattices
 `fiber:intersection`    | Intersections point of fibers
 `fiber:hand`            | Position of hands attached to fibers
 `fiber:link`            | Positions of attached hands for which stiffness > 0
 `fiber:cluster`         | Clusters made of fibers connected by Couples


 WHAT                    | Output
 ------------------------|------------------------------------------------------
 `bead:all`              | Position of beads
 `bead:single`           | Number of Beads with no single attached, 1 single attached etc.
 `solid:hand`            | Number of hands and number of attached hands on Solids
 `spindle:indice`        | Two scalar indices that caracterize the organization of fibers
 `spindle:profile`       | Number of right- and left-pointing fiber as a function of position
 `single:all`            | Position and force of singles
 `single:NAME`           | Position and force of singles of class NAME
 `single:position:NAME`  | Position and force of singles of class NAME
 `couple:state`          | Position and state of all couples
 `couple:NAME`           | Position and state of couples of class NAME
 `couple:link`           | detailed information on doubly-attached couples
 `couple:configuration`  | number of Couples in { X, P, A, V, T } states
 `couple:force`          | Histogram of tension in the couple links
 `couple:active`         | Position of active couples
 `couple:anatomy`        | Composition of couples
 `couple:NAME`           | Position of couples of class NAME
 `couple:hands`          | Composition of couples
