# Articles describing Cytosim and related work

- [Collective Langevin Dynamics of Flexible Cytoskeletal Fibers](http://dx.doi.org/10.1088/1367-2630/9/11/427)  

- [Preconfig: A Versatile Configuration File Generator for Varying Parameters](http://doi.org/10.5334/jors.156)  


# Cytosim used in other groups

*Please, let us know of any citation we could add*

2021

- [Self-organized optimal packing of kinesin-5-driven microtubule asters scales with cell size](https://doi.org/10.1242/jcs.257543)
- [Effect of plant tubulin kinetic diversification on microtubule lengths](https://www.biorxiv.org/content/10.1101/2021.05.11.443582v1)
- [Dynein self-organizes while translocating the centrosome in T cells](https://www.molbiolcell.org/doi/abs/10.1091/mbc.E20-10-0668)
- [Kinesin-4 KIF21B limits microtubule growth to allow rapid centrosome polarization in T cells](https://doi.org/10.7554/eLife.62876)
- [Crowder and Surface Effects on Self-organization of Microtubules](https://arxiv.org/abs/2009.04669)[PDF](https://arxiv.org/pdf/2009.04669.pdf)
- [Actin crosslinker competition and sorting drive emergent GUV size-dependent actin network architecture](https://doi.org/10.1038/s42003-021-02653-6)
- [Actin force generation in vesicle formation: mechanistic insights from cryo- electron tomography](https://doi.org/10.1101/2021.06.28.450262)
- [Thermodynamic Control of Activity Patterns in Cytoskeletal Networks](https://arxiv.org/pdf/2111.08677.pdf)
- [Plastin and spectrin cooperate to stabilize the actomyosin cortex during cytokinesis](https://doi.org/10.1016/j.cub.2021.09.055)

2020

- [Dynein collective behavior in mitotic nuclear positioning of Saccharomyces cerevisiae](https://www.biorxiv.org/content/10.1101/2020.06.23.166769v2.abstract)
- [Differences in Intrinsic Tubulin Dynamic Properties Contribute to Spindle Length Control in Xenopus Species](https://doi.org/10.1016/j.cub.2020.03.067)
- [Principles of self-organization and load adaptation by the actin cytoskeleton during clathrin-mediated endocytosis](https://doi.org/10.7554/eLife.49840)  
- [Mechanosensitive single molecule dynamics of myosin II](http://hdl.handle.net/2445/171220)
- [Reverse-engineering forces responsible for dynamic clustering and spreading of multiple nuclei in developing muscle cells](https://doi.org/10.1091/mbc.E19-12-0711)
- [Wrinkling instability in 3D active nematics](https://pubs.acs.org/doi/abs/10.1021/acs.nanolett.0c01546)
- [Deep learning the assembly parameters of growing cytoskeletal networks](https://pure.tue.nl/ws/portalfiles/portal/148470406/Kros_M.F._0875844_BEP_verslag.pdf) Kros, Maury F, Eindhoven University.
- [Prospects for Declarative Mathematical Modeling of Complex Biological Systems](https://arxiv.org/abs/1804.11044)
- [Chromosomes function as a barrier to mitotic spindle bipolarity in polyploid cells](https://doi.org/10.1083/jcb.201908006)   

2019

- [Deep learning the assembly parameters of growing cytoskeletal networks](https://pure.tue.nl/ws/portalfiles/portal/148470406/Kros_M.F._0875844_BEP_verslag.pdf)
- [PP2A-B55/SUR-6 collaborates with the nuclear lamina for centrosome separation during mitotic entry](https://doi.org/10.1091/mbc.E18-10-0631)
- [Spherical spindle shape promotes perpendicular cortical orientation by preventing isometric cortical pulling on both spindle poles during C. elegans female meiosis](http://dx.doi.org/10.1242/dev.178863)  
- [Collective effects of yeast cytoplasmic dynein based microtubule transport](http://dx.doi.org/10.1039/c8sm01434e)  
- [Prospects for Declarative Mathematical Modeling of Complex Biological Systems](https://arxiv.org/pdf/1804.11044.pdf)  
- [Visualization of myosin II filament dynamics in remodeling acto-myosin networks with interferometric scattering microscopy](https://www.biorxiv.org/content/10.1101/199778v4)  
- [Spherical Spindle Shape Promotes Perpendicular Cortical Orientation by Preventing Isometric Cortical Pulling on both Spindle Poles during C. elegans Female Meiosis](https://www.biorxiv.org/content/10.1101/596510v1)  
- [Centrosome-nuclear envelope tethering and microtubule motor-based pulling forces collaborate in centrosome positioning during mitotic entry](https://www.biorxiv.org/content/10.1101/442368v1)  

2018

- [Microrheology of Actin Networks](https://webthesis.biblio.polito.it/9576/1/tesi.pdf)
- [Mechanical positioning of multiple nuclei in muscle cells](https://doi.org/10.1371/journal.pcbi.1006208)
- [Role of External Forcing in Directional Instability of Microtubule Transport](http://dr.iiserpune.ac.in:8080/xmlui/handle/123456789/987)
- [Entropy production rate is maximized in non- contractile actomyosin](http://dx.doi.org/10.1038/s41467-018-07413-5)
- [Evolutionary mechanisms of asymmetric spindle positioning in nematode embyos](http://dr.iiserpune.ac.in:8080/xmlui/handle/123456789/1007)
- [Role of External Forcing in Directional Instability of Microtubule Transport]()

2017

- [Programmable Active Matter: Dynamics of active filaments on patterned surfaces](https://ui.adsabs.harvard.edu/abs/2017APS..MARR14013Y/abstract)
- [Microtubule stabilization drives 3D centrosome migration to initiate primary ciliogenesis](https://doi.org/10.1083/jcb.201610039)
- [A Versatile Framework for Simulating the Dynamic Mechanical Structure of Cytoskeletal Networks](https://doi.org/10.1016/j.bpj.2017.06.003)
- [Centrosome Centering and Decentering by Microtubule Network Rearrangement](https://doi.org/10.4172/2168-9431.1000158)
- [Computer simulations reveal mechanisms that organize nuclear dynein forces to separate centrosomes](http://molbiolcell.org/cgi/doi/10.1091/mbc.E16-12-0823)
- [Image analysis and modeling of cellular organization in micropatterned environments](https://archiv.ub.uni-heidelberg.de/volltextserver/22837/)
- [Polarity Reversal by Centrosome Repositioning Primes Cell Scattering during Epithelial-to-Mesenchymal Transition](http://dx.doi.org/10.1016/j.devcel.2016.12.004)

2016

- [A Motor-Gradient and Clustering Model of the Centripetal Motility of MTOCs in Meiosis I of Mouse Oocytes](https://doi.org/10.1371/journal.pcbi.1005102)

2015

- [Dynamic reorganization of the actin cytoskeleton](http://dx.doi.org/10.12688/f1000research.6374.1)

2013

- [Model of Fission Yeast Cell Shape Driven by Membrane- Bound Growth Factors and the Cytoskeleton](http://dx.doi.org/10.1371/journal.pcbi.1003287)
- [Analysis of the local organization and dynamics of cellular actin networks](http://dx.doi.org/10.1083/jcb.201210123)

2012

- [Spatial and Temporal Sensing Limits of Microtubule Polarization in Neuronal Growth Cones by Intracellular Gradients and Forces](http://dx.doi.org/10.1016/j.bpj.2012.10.021)

