# Generated by Django 3.0.6 on 2020-06-16 08:54

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='BusinessForm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'cégforma',
                'verbose_name_plural': 'cégformák',
                'db_table': 'business_forms',
            },
        ),
        migrations.CreateModel(
            name='Contribution',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'járulék',
                'verbose_name_plural': 'járulékok',
                'db_table': 'contributions',
            },
        ),
        migrations.CreateModel(
            name='DependentQuality',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'eltartott minőség',
                'verbose_name_plural': 'eltartott minőségek',
                'db_table': 'dependent_qualities',
            },
        ),
        migrations.CreateModel(
            name='DependentRight',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'eltartott jogosultság',
                'verbose_name_plural': 'eltartott jogosultságok',
                'db_table': 'dependent_rights',
            },
        ),
        migrations.CreateModel(
            name='Legal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'jogviszony',
                'verbose_name_plural': 'jogviszonyok',
                'db_table': 'legals',
            },
        ),
        migrations.CreateModel(
            name='PauseCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'biztosítás szünetelése',
                'verbose_name_plural': 'biztosítás szünetelések',
                'db_table': 'category_pause',
            },
        ),
        migrations.CreateModel(
            name='PayrollMode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'számfejtés módja',
                'verbose_name_plural': 'számfejtés módjai',
                'db_table': 'payroll_modes',
            },
        ),
        migrations.CreateModel(
            name='Pretence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'jogcím',
                'verbose_name_plural': 'jogcímek',
                'db_table': 'pretences',
            },
        ),
        migrations.CreateModel(
            name='RevenueBase',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'jövedelem alapja',
                'verbose_name_plural': 'jövedelem alapok',
                'db_table': 'revenue_bases',
            },
        ),
        migrations.CreateModel(
            name='RevenueType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'jövedelem típus',
                'verbose_name_plural': 'jövedelem típusok',
                'db_table': 'revenue_types',
            },
        ),
        migrations.CreateModel(
            name='Tax',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'adónem',
                'verbose_name_plural': 'adónemek',
                'db_table': 'taxes',
            },
        ),
        migrations.CreateModel(
            name='TimeSheet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('current_year', models.PositiveIntegerField(verbose_name='tárgyév')),
                ('current_month', models.PositiveSmallIntegerField(verbose_name='tárgyhó')),
            ],
            options={
                'verbose_name': 'jelenléti ív',
                'verbose_name_plural': 'jelenléti ívek',
                'db_table': 'timesheets',
            },
        ),
        migrations.CreateModel(
            name='TimeSheetCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'jelenléti ív törzs',
                'verbose_name_plural': 'jelenléti ív törzsek',
                'db_table': 'category_timesheet',
            },
        ),
        migrations.CreateModel(
            name='Title',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'előtag',
                'verbose_name_plural': 'előtagok',
                'db_table': 'titles',
            },
        ),
        migrations.CreateModel(
            name='UniformBookingClassificationSystem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
            ],
            options={
                'verbose_name': 'FEAOR kód',
                'verbose_name_plural': 'FEAOR kódok',
                'db_table': 'ubcs_codes',
            },
        ),
        migrations.CreateModel(
            name='WorkDay',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name': 'munkanap',
                'verbose_name_plural': 'munkanapok',
                'db_table': 'workdays',
            },
        ),
        migrations.CreateModel(
            name='WorkSheet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name': 'munkalap',
                'verbose_name_plural': 'munkalapok',
                'db_table': 'worksheets',
            },
        ),
        migrations.CreateModel(
            name='TimeSheetStatistic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.DurationField(blank=True, default=None, null=True)),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='categories', to='masterdata.TimeSheetCategory', verbose_name='kategória')),
                ('sheet', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='timesheets', to='masterdata.TimeSheet', verbose_name='jelenléti')),
            ],
        ),
        migrations.CreateModel(
            name='TimeSheetItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('timestamp', models.DateField(verbose_name='dátum')),
                ('duration', models.DurationField(verbose_name='munkaórák')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='aspects', to='masterdata.TimeSheetCategory', verbose_name='típus')),
                ('sheet', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='owners', to='masterdata.TimeSheet', verbose_name='jelenléti')),
            ],
        ),
        migrations.CreateModel(
            name='Pause',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('begin', models.DateField(blank=True, default=None, null=True, verbose_name='kezdet')),
                ('end', models.DateField(blank=True, default=None, null=True, verbose_name='vég')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='categories', to='masterdata.PauseCategory', verbose_name='kategória')),
            ],
            options={
                'verbose_name': 'biztosítás szünetelése',
                'verbose_name_plural': 'biztosítás szünetelések',
                'db_table': 'pauses',
            },
        ),
        migrations.CreateModel(
            name='Discount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, default=None, max_length=100, null=True, verbose_name='kód')),
                ('name', models.CharField(blank=True, default=None, max_length=1000, null=True, verbose_name='megnevezés')),
                ('tax', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='discounts', to='masterdata.Tax', verbose_name='adónem')),
            ],
            options={
                'verbose_name': 'adókevezmény',
                'verbose_name_plural': 'adókevezmények',
                'db_table': 'discounts',
            },
        ),
    ]
