"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ELBMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class ELBMetrics {
    static latencyAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'Latency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static backendConnectionErrorsAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'BackendConnectionErrors',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static requestCountAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'RequestCount',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static spilloverCountAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'SpilloverCount',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static surgeQueueLengthAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'SurgeQueueLength',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static healthyHostCountAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HealthyHostCount',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static unHealthyHostCountAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'UnHealthyHostCount',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static httpCodeBackend2XxAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_2XX',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static httpCodeBackend3XxAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_3XX',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static httpCodeBackend4XxAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_4XX',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static httpCodeBackend5XxAverage(dimensions) {
        return {
            namespace: 'AWS/ELB',
            metricName: 'HTTPCode_Backend_5XX',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
}
exports.ELBMetrics = ELBMetrics;
//# sourceMappingURL=data:application/json;base64,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