"""

https://github.com/ManiacalLabs/BiblioPixel/blob
/master/bibliopixel/colors/juce.py

which came from

https://github.com/timedata-org/timedata/blob
/master/src/cpp/timedata/color/names_table_inl.h

which came from Juce: http://juce.com.
"""

COLORS = {
    'Alice blue': 0xF0F8FF,
    'Antique white 1': 0xFFEFDB,
    'Antique white 2': 0xEEDFCC,
    'Antique white 3': 0xCDC0B0,
    'Antique white 4': 0x8B8378,
    'Antique white': 0xFAEBD7,
    'Aqua': 0x00FFFF,
    'Aquamarine 1': 0x7FFFD4,
    'Aquamarine 2': 0x76EEC6,
    'Aquamarine 3': 0x66CDAA,
    'Aquamarine 4': 0x458B74,
    'Aquamarine': 0x7FFFD4,
    'Azure 1': 0xF0FFFF,
    'Azure 2': 0xE0EEEE,
    'Azure 3': 0xC1CDCD,
    'Azure 4': 0x838B8B,
    'Azure': 0xF0FFFF,
    'Banana': 0xE3CF57,
    'Beige': 0xF5F5DC,
    'Bisque 1': 0xFFE4C4,
    'Bisque 2': 0xEED5B7,
    'Bisque 3': 0xCDB79E,
    'Bisque 4': 0x8B7D6B,
    'Bisque': 0xFFE4C4,
    'Black': 0x000000,
    'Blanched almond': 0xFFEBCD,
    'Blue 2': 0x0000EE,
    'Blue 3': 0x0000CD,
    'Blue 4': 0x00008B,
    'Blue violet': 0x8A2BE2,
    'Blue': 0x0000FF,
    'Brick': 0x9C661F,
    'Brown 1': 0xFF4040,
    'Brown 2': 0xEE3B3B,
    'Brown 3': 0xCD3333,
    'Brown 4': 0x8B2323,
    'Brown': 0xA52A2A,
    'Burly wood 1': 0xFFD39B,
    'Burly wood 2': 0xEEC591,
    'Burly wood 3': 0xCDAA7D,
    'Burly wood 4': 0x8B7355,
    'Burly wood': 0xDEB887,
    'Burnt sienna': 0x8A360F,
    'Burnt umber': 0x8A3324,
    'Cadet blue 1': 0x98F5FF,
    'Cadet blue 2': 0x8EE5EE,
    'Cadet blue 3': 0x7AC5CD,
    'Cadet blue 4': 0x53868B,
    'Cadet blue': 0x5F9EA0,
    'Cadmium orange': 0xFF6103,
    'Cadmium yellow': 0xFF9912,
    'Carrot': 0xED9121,
    'Chartreuse 1': 0x7FFF00,
    'Chartreuse 2': 0x76EE00,
    'Chartreuse 3': 0x66CD00,
    'Chartreuse 4': 0x458B00,
    'Chartreuse': 0x7FFF00,
    'Chocolate 1': 0xFF7F24,
    'Chocolate 2': 0xEE7621,
    'Chocolate 3': 0xCD661D,
    'Chocolate 4': 0x8B4513,
    'Chocolate': 0xD2691E,
    'Cobalt green': 0x3D9140,
    'Cobalt': 0x3D59AB,
    'Cold grey': 0x808A87,
    'Coral 1': 0xFF7256,
    'Coral 2': 0xEE6A50,
    'Coral 3': 0xCD5B45,
    'Coral 4': 0x8B3E2F,
    'Coral': 0xFF7F50,
    'Corn silk 1': 0xFFF8DC,
    'Corn silk 2': 0xEEE8CD,
    'Corn silk 3': 0xCDC8B1,
    'Corn silk 4': 0x8B8878,
    'Corn silk': 0xFFF8DC,
    'Cornflower blue': 0x6495ED,
    'Crimson': 0xDC143C,
    'Cyan 2': 0x00EEEE,
    'Cyan 3': 0x00CDCD,
    'Cyan 4': 0x008B8B,
    'Cyan': 0x00FFFF,
    'Dark blue': 0x00008B,
    'Dark cyan': 0x008B8B,
    'Dark goldenrod 1': 0xFFB90F,
    'Dark goldenrod 2': 0xEEAD0E,
    'Dark goldenrod 3': 0xCD950C,
    'Dark goldenrod 4': 0x8B6508,
    'Dark goldenrod': 0xB8860B,
    'Dark green': 0x006400,
    'Dark grey': 0x555555,
    'Dark khaki': 0xBDB76B,
    'Dark magenta': 0x8B008B,
    'Dark olive green': 0x556B2F,
    'Dark olivegreen 1': 0xCAFF70,
    'Dark olivegreen 2': 0xBCEE68,
    'Dark olivegreen 3': 0xA2CD5A,
    'Dark olivegreen 4': 0x6E8B3D,
    'Dark olivegreen': 0x556B2F,
    'Dark orange 1': 0xFF7F00,
    'Dark orange 2': 0xEE7600,
    'Dark orange 3': 0xCD6600,
    'Dark orange 4': 0x8B4500,
    'Dark orange': 0xFF8C00,
    'Dark orchid 1': 0xBF3EFF,
    'Dark orchid 2': 0xB23AEE,
    'Dark orchid 3': 0x9A32CD,
    'Dark orchid 4': 0x68228B,
    'Dark orchid': 0x9932CC,
    'Dark red': 0x8B0000,
    'Dark salmon': 0xE9967A,
    'Dark sea green 1': 0xC1FFC1,
    'Dark sea green 2': 0xB4EEB4,
    'Dark sea green 3': 0x9BCD9B,
    'Dark sea green 4': 0x698B69,
    'Dark sea green': 0x8FBC8F,
    'Dark slate blue': 0x483D8B,
    'Dark slate grey 1': 0x97FFFF,
    'Dark slate grey 2': 0x8DEEEE,
    'Dark slate grey 3': 0x79CDCD,
    'Dark slate grey 4': 0x528B8B,
    'Dark slate grey': 0x2F4F4F,
    'Dark turquoise': 0x00CED1,
    'Dark violet': 0x9400D3,
    'Deep pink 1': 0xFF1493,
    'Deep pink 2': 0xEE1289,
    'Deep pink 3': 0xCD1076,
    'Deep pink 4': 0x8B0A50,
    'Deep pink': 0xFF1493,
    'Deep sky blue 1': 0x00BFFF,
    'Deep sky blue 2': 0x00B2EE,
    'Deep sky blue 3': 0x009ACD,
    'Deep sky blue 4': 0x00688B,
    'Deep sky blue': 0x00BFFF,
    'Dim grey': 0x696969,
    'Dodger blue 1': 0x1E90FF,
    'Dodger blue 2': 0x1C86EE,
    'Dodger blue 3': 0x1874CD,
    'Dodger blue 4': 0x104E8B,
    'Dodger blue': 0x1E90FF,
    'Eggshell': 0xFCE6C9,
    'Emerald green': 0x00C957,
    'Fire brick 1': 0xFF3030,
    'Fire brick 2': 0xEE2C2C,
    'Fire brick 3': 0xCD2626,
    'Fire brick 4': 0x8B1A1A,
    'Fire brick': 0xB22222,
    'Flesh': 0xFF7D40,
    'Floral white': 0xFFFAF0,
    'Forest green': 0x228B22,
    'Fuchsia': 0xFF00FF,
    'Gainsboro': 0xDCDCDC,
    'Ghost white': 0xF8F8FF,
    'Gold 1': 0xFFD700,
    'Gold 2': 0xEEC900,
    'Gold 3': 0xCDAD00,
    'Gold 4': 0x8B7500,
    'Gold': 0xFFD700,
    'Goldenrod 1': 0xFFC125,
    'Goldenrod 2': 0xEEB422,
    'Goldenrod 3': 0xCD9B1D,
    'Goldenrod 4': 0x8B6914,
    'Goldenrod': 0xDAA520,
    'Gray': 0x808080,
    'Green 1': 0x00FF00,
    'Green 2': 0x00EE00,
    'Green 3': 0x00CD00,
    'Green 4': 0x008B00,
    'Green yellow': 0xADFF2F,
    'Green': 0x00FF00,
    'Grey': 0x808080,
    'Honeydew 1': 0xF0FFF0,
    'Honeydew 2': 0xE0EEE0,
    'Honeydew 3': 0xC1CDC1,
    'Honeydew 4': 0x838B83,
    'Honeydew': 0xF0FFF0,
    'Hot pink 1': 0xFF6EB4,
    'Hot pink 2': 0xEE6AA7,
    'Hot pink 3': 0xCD6090,
    'Hot pink 4': 0x8B3A62,
    'Hot pink': 0xFF69B4,
    'Indian red 1': 0xFF6A6A,
    'Indian red 2': 0xEE6363,
    'Indian red 3': 0xCD5555,
    'Indian red 4': 0x8B3A3A,
    'Indian red': 0xCD5C5C,
    'Indigo': 0x4B0082,
    'Ivory 1': 0xFFFFF0,
    'Ivory 2': 0xEEEEE0,
    'Ivory 3': 0xCDCDC1,
    'Ivory 4': 0x8B8B83,
    'Ivory black': 0x292421,
    'Ivory': 0xFFFFF0,
    'Khaki 1': 0xFFF68F,
    'Khaki 2': 0xEEE685,
    'Khaki 3': 0xCDC673,
    'Khaki 4': 0x8B864E,
    'Khaki': 0xF0E68C,
    'Lavender blush 1': 0xFFF0F5,
    'Lavender blush 2': 0xEEE0E5,
    'Lavender blush 3': 0xCDC1C5,
    'Lavender blush 4': 0x8B8386,
    'Lavender blush': 0xFFF0F5,
    'Lavender': 0xE6E6FA,
    'Lawn green': 0x7CFC00,
    'Lemon chiffon 1': 0xFFFACD,
    'Lemon chiffon 2': 0xEEE9BF,
    'Lemon chiffon 3': 0xCDC9A5,
    'Lemon chiffon 4': 0x8B8970,
    'Lemon chiffon': 0xFFFACD,
    'Light blue 1': 0xBFEFFF,
    'Light blue 2': 0xB2DFEE,
    'Light blue 3': 0x9AC0CD,
    'Light blue 4': 0x68838B,
    'Light blue': 0xADD8E6,
    'Light coral': 0xF08080,
    'Light cyan 1': 0xE0FFFF,
    'Light cyan 2': 0xD1EEEE,
    'Light cyan 3': 0xB4CDCD,
    'Light cyan 4': 0x7A8B8B,
    'Light cyan': 0xE0FFFF,
    'Light goldenrod 1': 0xFFEC8B,
    'Light goldenrod 2': 0xEEDC82,
    'Light goldenrod 3': 0xCDBE70,
    'Light goldenrod 4': 0x8B814C,
    'Light goldenrod yellow': 0xFAFAD2,
    'Light green': 0x90EE90,
    'Light grey': 0xD3D3D3,
    'Light pink 1': 0xFFAEB9,
    'Light pink 2': 0xEEA2AD,
    'Light pink 3': 0xCD8C95,
    'Light pink 4': 0x8B5F65,
    'Light pink': 0xFFB6C1,
    'Light salmon 1': 0xFFA07A,
    'Light salmon 2': 0xEE9572,
    'Light salmon 3': 0xCD8162,
    'Light salmon 4': 0x8B5742,
    'Light salmon': 0xFFA07A,
    'Light sea green': 0x20B2AA,
    'Light sky blue 1': 0xB0E2FF,
    'Light sky blue 2': 0xA4D3EE,
    'Light sky blue 3': 0x8DB6CD,
    'Light sky blue 4': 0x607B8B,
    'Light sky blue': 0x87CEFA,
    'Light slate blue': 0x8470FF,
    'Light slate grey': 0x778899,
    'Light steel blue 1': 0xCAE1FF,
    'Light steel blue 2': 0xBCD2EE,
    'Light steel blue 3': 0xA2B5CD,
    'Light steel blue 4': 0x6E7B8B,
    'Light steel blue': 0xB0C4DE,
    'Light yellow 1': 0xFFFFE0,
    'Light yellow 2': 0xEEEED1,
    'Light yellow 3': 0xCDCDB4,
    'Light yellow 4': 0x8B8B7A,
    'Light yellow': 0xFFFFE0,
    'Lime green': 0x32CD32,
    'Lime': 0x00FF00,
    'Limegreen': 0x32CD32,
    'Linen': 0xFAF0E6,
    'Magenta 2': 0xEE00EE,
    'Magenta 3': 0xCD00CD,
    'Magenta 4': 0x8B008B,
    'Magenta': 0xFF00FF,
    'Manganese blue': 0x03A89E,
    'Maroon 1': 0xFF34B3,
    'Maroon 2': 0xEE30A7,
    'Maroon 3': 0xCD2990,
    'Maroon 4': 0x8B1C62,
    'Maroon': 0x800000,
    'Medium aquamarine': 0x66CDAA,
    'Medium blue': 0x0000CD,
    'Medium orchid 1': 0xE066FF,
    'Medium orchid 2': 0xD15FEE,
    'Medium orchid 3': 0xB452CD,
    'Medium orchid 4': 0x7A378B,
    'Medium orchid': 0xBA55D3,
    'Medium purple 1': 0xAB82FF,
    'Medium purple 2': 0x9F79EE,
    'Medium purple 3': 0x8968CD,
    'Medium purple 4': 0x5D478B,
    'Medium purple': 0x9370DB,
    'Medium sea green': 0x3CB371,
    'Medium seagreen': 0x3CB371,
    'Medium slate blue': 0x7B68EE,
    'Medium slateblue': 0x7B68EE,
    'Medium spring green': 0x00FA9A,
    'Medium turquoise': 0x48D1CC,
    'Medium violet red': 0xC71585,
    'Medium violetred': 0xC71585,
    'Melon': 0xE3A869,
    'Midnight blue': 0x191970,
    'Mint cream': 0xF5FFFA,
    'Mint': 0xBDFCC9,
    'Misty rose 1': 0xFFE4E1,
    'Misty rose 2': 0xEED5D2,
    'Misty rose 3': 0xCDB7B5,
    'Misty rose 4': 0x8B7D7B,
    'Misty rose': 0xFFE4E1,
    'Moccasin': 0xFFE4B5,
    'Navajo white 1': 0xFFDEAD,
    'Navajo white 2': 0xEECFA1,
    'Navajo white 3': 0xCDB38B,
    'Navajo white 4': 0x8B795E,
    'Navajo white': 0xFFDEAD,
    'Navy': 0x000080,
    'None': 0x000000,
    'Old lace': 0xFDF5E6,
    'Olive drab 1': 0xC0FF3E,
    'Olive drab 2': 0xB3EE3A,
    'Olive drab 3': 0x9ACD32,
    'Olive drab 4': 0x698B22,
    'Olive drab': 0x6B8E23,
    'Olive': 0x808000,
    'Orange 1': 0xFFA500,
    'Orange 2': 0xEE9A00,
    'Orange 3': 0xCD8500,
    'Orange 4': 0x8B5A00,
    'Orange red 1': 0xFF4500,
    'Orange red 2': 0xEE4000,
    'Orange red 3': 0xCD3700,
    'Orange red 4': 0x8B2500,
    'Orange red': 0xFF4500,
    'Orange': 0xFFA500,
    'Orchid 1': 0xFF83FA,
    'Orchid 2': 0xEE7AE9,
    'Orchid 3': 0xCD69C9,
    'Orchid 4': 0x8B4789,
    'Orchid': 0xDA70D6,
    'Pale goldenrod': 0xEEE8AA,
    'Pale green 1': 0x9AFF9A,
    'Pale green 2': 0x90EE90,
    'Pale green 3': 0x7CCD7C,
    'Pale green 4': 0x548B54,
    'Pale green': 0x98FB98,
    'Pale turquoise 1': 0xBBFFFF,
    'Pale turquoise 2': 0xAEEEEE,
    'Pale turquoise 3': 0x96CDCD,
    'Pale turquoise 4': 0x668B8B,
    'Pale turquoise': 0xAFEEEE,
    'Pale violet red 1': 0xFF82AB,
    'Pale violet red 2': 0xEE799F,
    'Pale violet red 3': 0xCD6889,
    'Pale violet red 4': 0x8B475D,
    'Pale violet red': 0xDB7093,
    'Papaya whip': 0xFFEFD5,
    'Peachpuff 1': 0xFFDAB9,
    'Peachpuff 2': 0xEECBAD,
    'Peachpuff 3': 0xCDAF95,
    'Peachpuff 4': 0x8B7765,
    'Peachpuff': 0xFFDAB9,
    'Peacock': 0x33A1C9,
    'Peru': 0xCD853F,
    'Pink 1': 0xFFB5C5,
    'Pink 2': 0xEEA9B8,
    'Pink 3': 0xCD919E,
    'Pink 4': 0x8B636C,
    'Pink': 0xFFC0CB,
    'Plum 1': 0xFFBBFF,
    'Plum 2': 0xEEAEEE,
    'Plum 3': 0xCD96CD,
    'Plum 4': 0x8B668B,
    'Plum': 0xDDA0DD,
    'Powder blue': 0xB0E0E6,
    'Purple 1': 0x9B30FF,
    'Purple 2': 0x912CEE,
    'Purple 3': 0x7D26CD,
    'Purple 4': 0x551A8B,
    'Purple': 0x800080,
    'Raspberry': 0x872657,
    'Raw sienna': 0xC76114,
    'Red 1': 0xFF0000,
    'Red 2': 0xEE0000,
    'Red 3': 0xCD0000,
    'Red 4': 0x8B0000,
    'Red': 0xFF0000,
    'Rosy brown 1': 0xFFC1C1,
    'Rosy brown 2': 0xEEB4B4,
    'Rosy brown 3': 0xCD9B9B,
    'Rosy brown 4': 0x8B6969,
    'Rosy brown': 0xBC8F8F,
    'Royal blue 1': 0x4876FF,
    'Royal blue 2': 0x436EEE,
    'Royal blue 3': 0x3A5FCD,
    'Royal blue 4': 0x27408B,
    'Royal blue': 0x4169E1,
    'Saddle brown': 0x8B4513,
    'Salmon 1': 0xFF8C69,
    'Salmon 2': 0xEE8262,
    'Salmon 3': 0xCD7054,
    'Salmon 4': 0x8B4C39,
    'Salmon': 0xFA8072,
    'Sandy brown': 0xF4A460,
    'Sap green': 0x308014,
    'Sea green 1': 0x54FF9F,
    'Sea green 2': 0x4EEE94,
    'Sea green 3': 0x43CD80,
    'Sea green 4': 0x2E8B57,
    'Sea green': 0x2E8B57,
    'Seashell 1': 0xFFF5EE,
    'Seashell 2': 0xEEE5DE,
    'Seashell 3': 0xCDC5BF,
    'Seashell 4': 0x8B8682,
    'Seashell': 0xFFF5EE,
    'Sepia': 0x5E2612,
    'Sienna 1': 0xFF8247,
    'Sienna 2': 0xEE7942,
    'Sienna 3': 0xCD6839,
    'Sienna 4': 0x8B4726,
    'Sienna': 0xA0522D,
    'Silver': 0xC0C0C0,
    'Sky blue 1': 0x87CEFF,
    'Sky blue 2': 0x7EC0EE,
    'Sky blue 3': 0x6CA6CD,
    'Sky blue 4': 0x4A708B,
    'Sky blue': 0x87CEEB,
    'Slate blue 1': 0x836FFF,
    'Slate blue 2': 0x7A67EE,
    'Slate blue 3': 0x6959CD,
    'Slate blue 4': 0x473C8B,
    'Slate blue': 0x6A5ACD,
    'Slate grey 1': 0xC6E2FF,
    'Slate grey 2': 0xB9D3EE,
    'Slate grey 3': 0x9FB6CD,
    'Slate grey 4': 0x6C7B8B,
    'Slate grey': 0x708090,
    'Snow 1': 0xFFFAFA,
    'Snow 2': 0xEEE9E9,
    'Snow 3': 0xCDC9C9,
    'Snow 4': 0x8B8989,
    'Snow': 0xFFFAFA,
    'Spring green 1': 0x00EE76,
    'Spring green 2': 0x00CD66,
    'Spring green 3': 0x008B45,
    'Spring green': 0x00FF7F,
    'Steel blue 1': 0x63B8FF,
    'Steel blue 2': 0x5CACEE,
    'Steel blue 3': 0x4F94CD,
    'Steel blue 4': 0x36648B,
    'Steel blue': 0x4682B4,
    'Tan 1': 0xFFA54F,
    'Tan 2': 0xEE9A49,
    'Tan 3': 0xCD853F,
    'Tan 4': 0x8B5A2B,
    'Tan': 0xD2B48C,
    'Teal': 0x008080,
    'Thistle 1': 0xFFE1FF,
    'Thistle 2': 0xEED2EE,
    'Thistle 3': 0xCDB5CD,
    'Thistle 4': 0x8B7B8B,
    'Thistle': 0xD8BFD8,
    'Tomato 1': 0xFF6347,
    'Tomato 2': 0xEE5C42,
    'Tomato 3': 0xCD4F39,
    'Tomato 4': 0x8B3626,
    'Tomato': 0xFF6347,
    'Turquoise 1': 0x00F5FF,
    'Turquoise 2': 0x00E5EE,
    'Turquoise 3': 0x00C5CD,
    'Turquoise 4': 0x00868B,
    'Turquoise blue': 0x00C78C,
    'Turquoise': 0x40E0D0,
    'Violet red 1': 0xFF3E96,
    'Violet red 2': 0xEE3A8C,
    'Violet red 3': 0xCD3278,
    'Violet red 4': 0x8B2252,
    'Violet red': 0xD02090,
    'Violet': 0xEE82EE,
    'Warm grey': 0x808069,
    'Wheat 1': 0xFFE7BA,
    'Wheat 2': 0xEED8AE,
    'Wheat 3': 0xCDBA96,
    'Wheat 4': 0x8B7E66,
    'Wheat': 0xF5DEB3,
    'White smoke': 0xF5F5F5,
    'White': 0xFFFFFF,
    'Yellow 1': 0xFFFF00,
    'Yellow 2': 0xEEEE00,
    'Yellow 3': 0xCDCD00,
    'Yellow 4': 0x8B8B00,
    'Yellow green': 0x9ACD32,
    'Yellow': 0xFFFF00,
}

PRIMARY_NAMES = {
    'Black',
    'Cyan',
    'Dark blue',
    'Dark cyan',
    'Dark magenta',
    'Dark olive green',
    'Dark red',
    'Green',
    'Lime green',
    'Magenta',
    'Medium aquamarine',
    'Medium blue',
    'Medium sea green',
    'Medium slate blue',
    'Medium violet red',
    'Saddle brown',
    'Yellow green',
}

"""
Some colors have more than one name.  This is a list of the secondary names for
Juce colors.  We need this to reliably go from color back to color name and
get the same result each time.

TODO: Invert these to be PRIMARY_NAMES
"""
SECONDARY_NAMES = {
    'Aqua',
    'Aquamarine 1',
    'Aquamarine 3',
    'Azure 1',
    'Bisque 1',
    'Blue 3',
    'Blue 4',
    'Chartreuse 1',
    'Chocolate 4',
    'Corn silk 1',
    'Cyan 4',
    'Dark olivegreen',
    'Deep pink 1',
    'Deep sky blue 1',
    'Dodger blue 1',
    'Fuchsia',
    'Gold 1',
    'Green 1',
    'Honeydew 1',
    'Ivory 1',
    'Lavender blush 1',
    'Lemon chiffon 1',
    'Light cyan 1',
    'Light salmon 1',
    'Light yellow 1',
    'Lime',
    'Limegreen',
    'Magenta 4',
    'Medium seagreen',
    'Medium slateblue',
    'Medium violetred',
    'Misty rose 1',
    'Navajo white 1',
    'None',
    'Olive drab 3',
    'Orange 1',
    'Orange red 1',
    'Pale green 2',
    'Peachpuff 1',
    'Red 1',
    'Red 4',
    'Sea green 4',
    'Seashell 1',
    'Snow 1',
    'Tan 3',
    'Tomato 1',
    'Yellow 1',
}
