from typing import List, Optional, Union

from com.inductiveautomation.ignition.common.messages import UIResponse
from com.inductiveautomation.ignition.common.user import PyUser, UserSourceMeta
from com.inductiveautomation.ignition.common.user.schedule import (
    AbstractScheduleModel,
    HolidayModel,
    ScheduleAdjustment,
)
from dev.thecesrom.helper.types import AnyStr
from java.util import Date

def addCompositeSchedule(
    name: AnyStr,
    scheduleOne: AnyStr,
    scheduleTwo: AnyStr,
    description: Optional[AnyStr] = ...,
) -> UIResponse: ...
def addHoliday(holiday: HolidayModel) -> UIResponse: ...
def addRole(userSource: AnyStr, role: AnyStr) -> UIResponse: ...
def addSchedule(schedule: AbstractScheduleModel) -> UIResponse: ...
def addUser(userSource: AnyStr, user: PyUser) -> UIResponse: ...
def createScheduleAdjustment(
    startDate: Date, endDate: Date, isAvailable: bool, note: AnyStr
) -> ScheduleAdjustment: ...
def editHoliday(holidayName: AnyStr, holiday: HolidayModel) -> UIResponse: ...
def editRole(userSource: AnyStr, oldName: AnyStr, newName: AnyStr) -> UIResponse: ...
def editSchedule(
    scheduleName: AnyStr, schedule: AbstractScheduleModel
) -> UIResponse: ...
def editUser(userSource: AnyStr, user: PyUser) -> UIResponse: ...
def getHoliday(holidayName: AnyStr) -> Optional[HolidayModel]: ...
def getHolidayNames() -> List[AnyStr]: ...
def getHolidays() -> List[HolidayModel]: ...
def getNewUser(userSource: AnyStr, username: AnyStr) -> PyUser: ...
def getRoles(userSource: AnyStr) -> List[AnyStr]: ...
def getSchedule(scheduleName: AnyStr) -> Optional[AbstractScheduleModel]: ...
def getScheduleNames() -> List[AnyStr]: ...
def getScheduledUsers(
    userSource: AnyStr, date: Optional[Union[Date, int]] = ...
) -> List[PyUser]: ...
def getSchedules() -> List[AbstractScheduleModel]: ...
def getUser(userSource: AnyStr, username: AnyStr) -> PyUser: ...
def getUserSources() -> List[UserSourceMeta]: ...
def getUsers(userSource: AnyStr) -> List[PyUser]: ...
def isUserScheduled(user: PyUser, date: Optional[Union[Date, int]] = ...) -> bool: ...
def removeHoliday(holidayName: AnyStr) -> UIResponse: ...
def removeRole(userSource: AnyStr, role: AnyStr) -> UIResponse: ...
def removeSchedule(scheduleName: AnyStr) -> UIResponse: ...
def removeUser(userSource: AnyStr, username: AnyStr) -> UIResponse: ...
