from typing import Any, Iterator, List, Optional

from dev.thecesrom.helper.types import AnyStr as AnyStr
from java.io import Writer
from java.lang import Number, Object

class JSONArray(Object):
    def __init__(self, arg: Any = ...) -> None: ...
    def get(self, index: int) -> Object: ...
    def getBoolean(self, index: int) -> bool: ...
    def getDouble(self, index: int) -> float: ...
    def getInt(self, index: int) -> int: ...
    def getJSONArray(self, index: int) -> JSONArray: ...
    def getJSONObject(self, index: int) -> JSONObject: ...
    def getLong(self, index: int) -> long: ...
    def getString(self, index: int) -> AnyStr: ...
    def isNull(self, index: int) -> bool: ...
    def join(self, separator: AnyStr) -> AnyStr: ...
    def length(self) -> int: ...
    def opt(self, index: int) -> Object: ...
    def optBoolean(self, index: int, defaultValue: Optional[bool] = ...) -> bool: ...
    def optDouble(self, index: int, defaultValue: Optional[float] = ...) -> float: ...
    def optInt(self, index: int, defaultValue: Optional[int] = ...) -> int: ...
    def optJSONArray(self, index: int) -> JSONArray: ...
    def optJSONObject(self, index: int) -> JSONObject: ...
    def optLong(self, index: int, defaultValue: Optional[long] = ...) -> long: ...
    def optString(self, index: int, defaultValue: Optional[AnyStr] = ...) -> AnyStr: ...
    def put(self, index: int, value: Any) -> JSONArray: ...
    def remove(self, index: int) -> Object: ...
    def toJSONObject(self, names: JSONArray) -> JSONObject: ...
    def toString(self, indentFactor: Optional[int] = ...) -> AnyStr: ...
    def write(self, writer: Writer) -> Writer: ...

class JSONObject(Object):
    NULL: Object
    def __init__(self, *args: Any) -> None: ...
    def accumulate(self, key: AnyStr, value: Object) -> JSONObject: ...
    def append(self, key: AnyStr, value: Object) -> JSONObject: ...
    @staticmethod
    def doubleToString(d: float) -> AnyStr: ...
    def get(self, key: AnyStr) -> Object: ...
    def getBoolean(self, key: AnyStr) -> bool: ...
    def getDouble(self, key: AnyStr) -> float: ...
    def getInt(self, key: AnyStr) -> int: ...
    def getJSONArray(self, key: AnyStr) -> JSONArray: ...
    def getJSONObject(self, key: AnyStr) -> JSONObject: ...
    def getLong(self, key: AnyStr) -> long: ...
    @staticmethod
    def getNames(arg: JSONObject) -> List[AnyStr]: ...
    def getString(self, key: AnyStr) -> AnyStr: ...
    def has(self, key: AnyStr) -> bool: ...
    def increment(self, key: AnyStr) -> JSONObject: ...
    def isNull(self, key: AnyStr) -> bool: ...
    def keys(self) -> Iterator[AnyStr]: ...
    def length(self) -> int: ...
    def names(self) -> JSONArray: ...
    @staticmethod
    def numberToString(n: Number) -> AnyStr: ...
    def opt(self, key: AnyStr) -> Object: ...
    def optBoolean(self, key: AnyStr, defaultValue: Optional[bool] = ...) -> bool: ...
    def optDouble(self, key: AnyStr, defaultValue: Optional[float] = ...) -> float: ...
    def optInt(self, key: AnyStr, defaultValue: Optional[int] = ...) -> int: ...
    def optJSONArray(self, key: AnyStr) -> JSONArray: ...
    def optJSONObject(self, key: AnyStr) -> JSONObject: ...
    def optLong(self, key: AnyStr, defaultValue: Optional[long] = ...) -> long: ...
    def optString(
        self, key: AnyStr, defaultValue: Optional[AnyStr] = ...
    ) -> AnyStr: ...
    def put(self, key: AnyStr, value: Any) -> JSONObject: ...
    def putOnce(self, key: AnyStr, value: Object) -> JSONObject: ...
    def putOpt(self, key: AnyStr, value: Object) -> JSONObject: ...
    @staticmethod
    def quote(string: AnyStr) -> AnyStr: ...
    def remove(self, key: AnyStr) -> Object: ...
    def sortedKeys(self) -> Iterator[AnyStr]: ...
    @staticmethod
    def stringToValue(s: AnyStr) -> Object: ...
    def toJSONArray(self, names: JSONArray) -> JSONArray: ...
    def toString(self, indentFactor: Optional[int] = ...) -> AnyStr: ...
    @staticmethod
    def valueToString(value: Object) -> AnyStr: ...
    @staticmethod
    def wrap(obj: Object) -> Object: ...
    def write(self, writer: Writer) -> Writer: ...
