# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr

class WorkerStatusTriggers(BaseModel):
    """
    Defines triggers that will be invoked per Worker outcome  # noqa: E501
    """
    started: Optional[StrictStr] = Field(None, description="Trigger to invoke when the Worker has Started")
    completed_with_results: Optional[StrictStr] = Field(None, alias="completedWithResults", description="Trigger to invoke when the Worker has Completed (with results)")
    completed_no_results: Optional[StrictStr] = Field(None, alias="completedNoResults", description="Trigger to invoke when the Worker has Completed (no results)")
    failed_to_start: Optional[StrictStr] = Field(None, alias="failedToStart", description="Trigger to invoke when the Worker has Failed to Start")
    failed_to_complete: Optional[StrictStr] = Field(None, alias="failedToComplete", description="Trigger to invoke when the Worker has Failed to Complete")
    __properties = ["started", "completedWithResults", "completedNoResults", "failedToStart", "failedToComplete"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WorkerStatusTriggers:
        """Create an instance of WorkerStatusTriggers from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if started (nullable) is None
        # and __fields_set__ contains the field
        if self.started is None and "started" in self.__fields_set__:
            _dict['started'] = None

        # set to None if completed_with_results (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_with_results is None and "completed_with_results" in self.__fields_set__:
            _dict['completedWithResults'] = None

        # set to None if completed_no_results (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_no_results is None and "completed_no_results" in self.__fields_set__:
            _dict['completedNoResults'] = None

        # set to None if failed_to_start (nullable) is None
        # and __fields_set__ contains the field
        if self.failed_to_start is None and "failed_to_start" in self.__fields_set__:
            _dict['failedToStart'] = None

        # set to None if failed_to_complete (nullable) is None
        # and __fields_set__ contains the field
        if self.failed_to_complete is None and "failed_to_complete" in self.__fields_set__:
            _dict['failedToComplete'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WorkerStatusTriggers:
        """Create an instance of WorkerStatusTriggers from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WorkerStatusTriggers.parse_obj(obj)

        _obj = WorkerStatusTriggers.parse_obj({
            "started": obj.get("started"),
            "completed_with_results": obj.get("completedWithResults"),
            "completed_no_results": obj.get("completedNoResults"),
            "failed_to_start": obj.get("failedToStart"),
            "failed_to_complete": obj.get("failedToComplete")
        })
        return _obj
