# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, constr, validator

class TaskTransitionDefinition(BaseModel):
    """
    Defines a State change  # noqa: E501
    """
    from_state: constr(strict=True, max_length=1024, min_length=1) = Field(..., alias="fromState", description="The State this Transition if coming From")
    to_state: constr(strict=True, max_length=1024, min_length=1) = Field(..., alias="toState", description="The State this Transition is going To")
    trigger: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="The Trigger for this Transition")
    guard: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="The Guard for this Transition, if any")
    action: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="The Action to invoke on successful Transition")
    __properties = ["fromState", "toState", "trigger", "guard", "action"]

    @validator('from_state')
    def from_state_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('to_state')
    def to_state_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('trigger')
    def trigger_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    @validator('guard')
    def guard_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[\s\S]*$", value):
            raise ValueError(r"must validate the regular expression /^[\s\S]*$/")
        return value

    @validator('action')
    def action_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TaskTransitionDefinition:
        """Create an instance of TaskTransitionDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if guard (nullable) is None
        # and __fields_set__ contains the field
        if self.guard is None and "guard" in self.__fields_set__:
            _dict['guard'] = None

        # set to None if action (nullable) is None
        # and __fields_set__ contains the field
        if self.action is None and "action" in self.__fields_set__:
            _dict['action'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TaskTransitionDefinition:
        """Create an instance of TaskTransitionDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TaskTransitionDefinition.parse_obj(obj)

        _obj = TaskTransitionDefinition.parse_obj({
            "from_state": obj.get("fromState"),
            "to_state": obj.get("toState"),
            "trigger": obj.get("trigger"),
            "guard": obj.get("guard"),
            "action": obj.get("action")
        })
        return _obj
