# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import BaseModel, Field, constr, validator
from lusid_workflow.models.resource_id import ResourceId

class SchedulerJob(BaseModel):
    """
    Configuration for a Worker that calls a Scheduler Job  # noqa: E501
    """
    type: constr(strict=True, min_length=1) = Field(..., description="The type of worker")
    job_id: ResourceId = Field(..., alias="jobId")
    __properties = ["type", "jobId"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('SchedulerJob'):
            raise ValueError("must be one of enum values ('SchedulerJob')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SchedulerJob:
        """Create an instance of SchedulerJob from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of job_id
        if self.job_id:
            _dict['jobId'] = self.job_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SchedulerJob:
        """Create an instance of SchedulerJob from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SchedulerJob.parse_obj(obj)

        _obj = SchedulerJob.parse_obj({
            "type": obj.get("type"),
            "job_id": ResourceId.from_dict(obj.get("jobId")) if obj.get("jobId") is not None else None
        })
        return _obj
