# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr, constr

class Parameter(BaseModel):
    """
    Defines a Worker Parameter  # noqa: E501
    """
    type: constr(strict=True, min_length=1) = Field(..., description="The type of this Parameter")
    name: constr(strict=True, min_length=1) = Field(..., description="Name")
    display_name: Optional[StrictStr] = Field(None, alias="displayName", description="DisplayName")
    description: Optional[StrictStr] = Field(None, description="Description")
    required: StrictBool = Field(..., description="Required or not")
    default_value: Optional[StrictStr] = Field(None, alias="defaultValue", description="DefaultValue")
    __properties = ["type", "name", "displayName", "description", "required", "defaultValue"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Parameter:
        """Create an instance of Parameter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if default_value (nullable) is None
        # and __fields_set__ contains the field
        if self.default_value is None and "default_value" in self.__fields_set__:
            _dict['defaultValue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Parameter:
        """Create an instance of Parameter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Parameter.parse_obj(obj)

        _obj = Parameter.parse_obj({
            "type": obj.get("type"),
            "name": obj.get("name"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "required": obj.get("required"),
            "default_value": obj.get("defaultValue")
        })
        return _obj
