# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr

class EventHandlerMapping(BaseModel):
    """
    Defines a mapping for event handler properties  # noqa: E501
    """
    map_from: Optional[StrictStr] = Field(None, alias="mapFrom", description="The field to map from")
    set_to: Optional[StrictStr] = Field(None, alias="setTo", description="The (constant) value to set")
    __properties = ["mapFrom", "setTo"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EventHandlerMapping:
        """Create an instance of EventHandlerMapping from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if map_from (nullable) is None
        # and __fields_set__ contains the field
        if self.map_from is None and "map_from" in self.__fields_set__:
            _dict['mapFrom'] = None

        # set to None if set_to (nullable) is None
        # and __fields_set__ contains the field
        if self.set_to is None and "set_to" in self.__fields_set__:
            _dict['setTo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EventHandlerMapping:
        """Create an instance of EventHandlerMapping from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EventHandlerMapping.parse_obj(obj)

        _obj = EventHandlerMapping.parse_obj({
            "map_from": obj.get("mapFrom"),
            "set_to": obj.get("setTo")
        })
        return _obj
