# lusid-workflow-sdk
FINBOURNE Technology

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.1086
- Package version: 2.1.39
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.finbourne.com](https://www.finbourne.com)

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/finbourne/workflow-sdk-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/finbourne/workflow-sdk-python.git`)

Then import the package:
```python
import lusid_workflow
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lusid_workflow
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

You'll need to provide some configuration to connect to the lusid_workflow application.
These can be provided using a secrets file or environment variables.

### Environment variables

In order to use [short lived access tokens](https://support.lusid.com/knowledgebase/article/KA-01654/en-us) you will need to have appropriate values set for the following environment variables:

``` 
FBN_TOKEN_URL,
FBN_LUSID_WORKFLOW_API_URL,
FBN_USERNAME,
FBN_PASSWORD,
FBN_CLIENT_ID,
FBN_CLIENT_SECRET
```

To use a long lived Personal Access Token, you must provide the following environment variables:
``` 
FBN_LUSID_WORKFLOW_API_URL,
FBN_ACCESS_TOKEN
```

You can send your requests to lusid_workflow via a proxy, by setting `FBN_PROXY_ADDRESS`. 
If your proxy has basic auth enabled, you must akso supply `FBN_PROXY_USERNAME` and `FBN_PROXY_PASSWORD`

### Secrets file

In order to use [short lived access tokens](https://support.lusid.com/knowledgebase/article/KA-01654/en-us) you will need to have appropriate values set in a `secrets.json` file in the same folder as your script.

``` 
{
    "api":
    {
        "tokenUrl":"<your-token-url>",
        "lusid_workflowUrl":"<FINBOURNE-application-url>",
        "username":"<your-username>",
        "password":"<your-password>",
        "clientId":"<your-client-id>",
        "clientSecret":"<your-client-secret>",
    }
}
```

To use a long lived Personal Access Token, you must provide a `secrets.json` with the following variables:
``` 
{
    "api":
    {
        "lusid_workflowUrl":"<FINBOURNE-application-url>",
        "accessToken":"<your-access-token>"
    }
}
```

You can send your requests to lusid_workflow via a proxy, by adding a proxy section to your `secrets.json`. 
If your proxy has basic auth enabled, you must also supply a `username` and `password` in this section.

``` 
{
    "api":
    {
        "lusid_workflowUrl":"<FINBOURNE-application-url>",
        "accessToken":"<your-access-token>"
    },
    "proxy":
    {
        "address":"<your-proxy-address>",
        "username":"<your-proxy-username>",
        "password":"<your-proxy-password>"
    }
}
```

### Using the SDK

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import lusid_workflow
from lusid_workflow.exceptions import ApiException
from pprint import pprint

import os
from lusid_workflow import (
    ApiClientFactory,
    ApplicationMetadataApi,
    EnvironmentVariablesConfigurationLoader,
    SecretsFileConfigurationLoader,
    ArgsConfigurationLoader
)

# Use the lusid_workflow ApiClientFactory to build Api instances with a configured api client
# By default this will read config from environment variables
# Then from a secrets.json file found in the current working directory
api_client_factory = ApiClientFactory()

# The ApiClientFactory can be passed an iterable of configuration loaders to read configuration from

api_url = "https://fbn-prd.lusid.com/workflow"
# Path to a secrets.json file containing authentication credentials
# See https://support.lusid.com/knowledgebase/article/KA-01667/en-us
# for a detailed guide to setting up the SDK make authenticated calls to LUSID APIs
secrets_path = os.getenv("FBN_SECRETS_PATH")
app_name="LusidJupyterNotebook"

config_loaders = [
	EnvironmentVariablesConfigurationLoader(),
	SecretsFileConfigurationLoader(api_secrets_file=secrets_path),
	ArgsConfigurationLoader(api_url=api_url, app_name=app_name)
]
api_client_factory = ApiClientFactory(config_loaders=config_loaders)


# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.



# Enter a context with an instance of the ApiClientFactory to ensure the connection pool is closed after use
async with api_client_factory:
    # Create an instance of the API class
    api_instance = api_client_factory.build(ApplicationMetadataApi)

    try:
        # [EXPERIMENTAL] ListAccessControlledResources: Get resources available for access control
        api_response = await api_instance.list_access_controlled_resources()
        print("The response of ApplicationMetadataApi->list_access_controlled_resources:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApplicationMetadataApi->list_access_controlled_resources: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://fbn-prd.lusid.com/workflow*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationMetadataApi* | [**list_access_controlled_resources**](docs/ApplicationMetadataApi.md#list_access_controlled_resources) | **GET** /api/metadata/access/resources | [EXPERIMENTAL] ListAccessControlledResources: Get resources available for access control
*EventHandlersApi* | [**create_event_handler**](docs/EventHandlersApi.md#create_event_handler) | **POST** /api/eventhandlers | [EXPERIMENTAL] CreateEventHandler: Create a new Event Handler
*EventHandlersApi* | [**delete_event_handler**](docs/EventHandlersApi.md#delete_event_handler) | **DELETE** /api/eventhandlers/{scope}/{code} | [EXPERIMENTAL] DeleteEventHandler: Delete an Event Handler
*EventHandlersApi* | [**get_event_handler**](docs/EventHandlersApi.md#get_event_handler) | **GET** /api/eventhandlers/{scope}/{code} | [EXPERIMENTAL] GetEventHandler: Get an Event Handler
*EventHandlersApi* | [**list_event_handlers**](docs/EventHandlersApi.md#list_event_handlers) | **GET** /api/eventhandlers | [EXPERIMENTAL] ListEventHandlers: List Event Handlers
*EventHandlersApi* | [**update_event_handler**](docs/EventHandlersApi.md#update_event_handler) | **PUT** /api/eventhandlers/{scope}/{code} | [EXPERIMENTAL] UpdateEventHandler: Update an existing Event handler
*TaskDefinitionsApi* | [**create_task_definition**](docs/TaskDefinitionsApi.md#create_task_definition) | **POST** /api/taskdefinitions | [EXPERIMENTAL] CreateTaskDefinition: Create a new Task Definition
*TaskDefinitionsApi* | [**delete_task_definition**](docs/TaskDefinitionsApi.md#delete_task_definition) | **DELETE** /api/taskdefinitions/{scope}/{code} | [EXPERIMENTAL] DeleteTaskDefinition: Delete a Task Definition
*TaskDefinitionsApi* | [**get_task_definition**](docs/TaskDefinitionsApi.md#get_task_definition) | **GET** /api/taskdefinitions/{scope}/{code} | [EXPERIMENTAL] GetTaskDefinition: Get a Task Definition
*TaskDefinitionsApi* | [**list_task_definitions**](docs/TaskDefinitionsApi.md#list_task_definitions) | **GET** /api/taskdefinitions | [EXPERIMENTAL] ListTaskDefinitions: List Task Definitions
*TaskDefinitionsApi* | [**list_tasks_for_task_definition**](docs/TaskDefinitionsApi.md#list_tasks_for_task_definition) | **GET** /api/taskdefinitions/{scope}/{code}/tasks | [EXPERIMENTAL] ListTasksForTaskDefinition: List Tasks for a Task Definition
*TaskDefinitionsApi* | [**update_task_definition**](docs/TaskDefinitionsApi.md#update_task_definition) | **PUT** /api/taskdefinitions/{scope}/{code} | [EXPERIMENTAL] UpdateTaskDefinition: Update an existing Task Definition
*TasksApi* | [**create_task**](docs/TasksApi.md#create_task) | **POST** /api/tasks | [EXPERIMENTAL] CreateTask: Create a new Task
*TasksApi* | [**delete_task**](docs/TasksApi.md#delete_task) | **DELETE** /api/tasks/{id} | [EXPERIMENTAL] DeleteTask: Delete a Task
*TasksApi* | [**get_task**](docs/TasksApi.md#get_task) | **GET** /api/tasks/{id} | [EXPERIMENTAL] GetTask: Get a Task
*TasksApi* | [**list_tasks**](docs/TasksApi.md#list_tasks) | **GET** /api/tasks | [EXPERIMENTAL] ListTasks: List Tasks
*TasksApi* | [**update_task**](docs/TasksApi.md#update_task) | **POST** /api/tasks/{id} | [EXPERIMENTAL] UpdateTask: Update a Task
*WorkersApi* | [**create_worker**](docs/WorkersApi.md#create_worker) | **POST** /api/workers | [EXPERIMENTAL] CreateWorker: Create a new Worker
*WorkersApi* | [**delete_worker**](docs/WorkersApi.md#delete_worker) | **DELETE** /api/workers/{scope}/{code} | [EXPERIMENTAL] DeleteWorker: Delete a Worker
*WorkersApi* | [**get_worker**](docs/WorkersApi.md#get_worker) | **GET** /api/workers/{scope}/{code} | [EXPERIMENTAL] GetWorker: Get a Worker
*WorkersApi* | [**get_worker_result**](docs/WorkersApi.md#get_worker_result) | **GET** /api/workers/{runId}/$result | [EXPERIMENTAL] GetWorkerResult: Get the status of a specific run of a worker with any relevant results
*WorkersApi* | [**list_workers**](docs/WorkersApi.md#list_workers) | **GET** /api/workers | [EXPERIMENTAL] ListWorkers: List Workers
*WorkersApi* | [**run_worker**](docs/WorkersApi.md#run_worker) | **POST** /api/workers/{scope}/{code}/$run | [EXPERIMENTAL] RunWorker: Run a Worker
*WorkersApi* | [**update_worker**](docs/WorkersApi.md#update_worker) | **PUT** /api/workers/{scope}/{code} | [EXPERIMENTAL] UpdateWorker: Update a Worker


## Documentation For Models

 - [AccessControlledAction](docs/AccessControlledAction.md)
 - [AccessControlledResource](docs/AccessControlledResource.md)
 - [ActionDefinition](docs/ActionDefinition.md)
 - [ActionDefinitionResponse](docs/ActionDefinitionResponse.md)
 - [ActionDetails](docs/ActionDetails.md)
 - [ActionDetailsResponse](docs/ActionDetailsResponse.md)
 - [ActionId](docs/ActionId.md)
 - [CreateChildTaskConfiguration](docs/CreateChildTaskConfiguration.md)
 - [CreateChildTasksAction](docs/CreateChildTasksAction.md)
 - [CreateChildTasksActionResponse](docs/CreateChildTasksActionResponse.md)
 - [CreateEventHandlerRequest](docs/CreateEventHandlerRequest.md)
 - [CreateNewTaskActivity](docs/CreateNewTaskActivity.md)
 - [CreateNewTaskActivityResponse](docs/CreateNewTaskActivityResponse.md)
 - [CreateTaskDefinitionRequest](docs/CreateTaskDefinitionRequest.md)
 - [CreateTaskRequest](docs/CreateTaskRequest.md)
 - [CreateWorkerRequest](docs/CreateWorkerRequest.md)
 - [DeletedEntityResponse](docs/DeletedEntityResponse.md)
 - [EventHandler](docs/EventHandler.md)
 - [EventHandlerMapping](docs/EventHandlerMapping.md)
 - [EventMatchingPattern](docs/EventMatchingPattern.md)
 - [Fail](docs/Fail.md)
 - [FailResponse](docs/FailResponse.md)
 - [FieldMapping](docs/FieldMapping.md)
 - [GetWorkerResultResponse](docs/GetWorkerResultResponse.md)
 - [HealthCheck](docs/HealthCheck.md)
 - [HealthCheckResponse](docs/HealthCheckResponse.md)
 - [IdSelectorDefinition](docs/IdSelectorDefinition.md)
 - [IdentifierPartSchema](docs/IdentifierPartSchema.md)
 - [InitialState](docs/InitialState.md)
 - [Link](docs/Link.md)
 - [LuminesceView](docs/LuminesceView.md)
 - [LuminesceViewResponse](docs/LuminesceViewResponse.md)
 - [LusidProblemDetails](docs/LusidProblemDetails.md)
 - [LusidValidationProblemDetails](docs/LusidValidationProblemDetails.md)
 - [PagedResourceListOfEventHandler](docs/PagedResourceListOfEventHandler.md)
 - [PagedResourceListOfTask](docs/PagedResourceListOfTask.md)
 - [PagedResourceListOfTaskDefinition](docs/PagedResourceListOfTaskDefinition.md)
 - [PagedResourceListOfWorker](docs/PagedResourceListOfWorker.md)
 - [Parameter](docs/Parameter.md)
 - [ParameterValue](docs/ParameterValue.md)
 - [ReadOnlyStates](docs/ReadOnlyStates.md)
 - [ResourceId](docs/ResourceId.md)
 - [ResourceListOfAccessControlledResource](docs/ResourceListOfAccessControlledResource.md)
 - [ResourceListOfTask](docs/ResourceListOfTask.md)
 - [ResultField](docs/ResultField.md)
 - [ResultMatchingPattern](docs/ResultMatchingPattern.md)
 - [ResultantChildTaskConfiguration](docs/ResultantChildTaskConfiguration.md)
 - [RunWorkerAction](docs/RunWorkerAction.md)
 - [RunWorkerActionResponse](docs/RunWorkerActionResponse.md)
 - [RunWorkerRequest](docs/RunWorkerRequest.md)
 - [RunWorkerResponse](docs/RunWorkerResponse.md)
 - [SchedulerJob](docs/SchedulerJob.md)
 - [SchedulerJobResponse](docs/SchedulerJobResponse.md)
 - [Sleep](docs/Sleep.md)
 - [SleepResponse](docs/SleepResponse.md)
 - [Stack](docs/Stack.md)
 - [Task](docs/Task.md)
 - [TaskActivity](docs/TaskActivity.md)
 - [TaskActivityResponse](docs/TaskActivityResponse.md)
 - [TaskDefinition](docs/TaskDefinition.md)
 - [TaskDefinitionVersion](docs/TaskDefinitionVersion.md)
 - [TaskFieldDefinition](docs/TaskFieldDefinition.md)
 - [TaskInstanceField](docs/TaskInstanceField.md)
 - [TaskStateDefinition](docs/TaskStateDefinition.md)
 - [TaskSummary](docs/TaskSummary.md)
 - [TaskTransitionDefinition](docs/TaskTransitionDefinition.md)
 - [TransitionTriggerDefinition](docs/TransitionTriggerDefinition.md)
 - [TriggerParentTaskAction](docs/TriggerParentTaskAction.md)
 - [TriggerParentTaskActionResponse](docs/TriggerParentTaskActionResponse.md)
 - [TriggerSchema](docs/TriggerSchema.md)
 - [UpdateEventHandlerRequest](docs/UpdateEventHandlerRequest.md)
 - [UpdateMatchingTasksActivity](docs/UpdateMatchingTasksActivity.md)
 - [UpdateMatchingTasksActivityResponse](docs/UpdateMatchingTasksActivityResponse.md)
 - [UpdateTaskDefinitionRequest](docs/UpdateTaskDefinitionRequest.md)
 - [UpdateTaskRequest](docs/UpdateTaskRequest.md)
 - [UpdateWorkerRequest](docs/UpdateWorkerRequest.md)
 - [ValueConstraints](docs/ValueConstraints.md)
 - [VersionInfo](docs/VersionInfo.md)
 - [Worker](docs/Worker.md)
 - [WorkerConfiguration](docs/WorkerConfiguration.md)
 - [WorkerConfigurationResponse](docs/WorkerConfigurationResponse.md)
 - [WorkerStatusTriggers](docs/WorkerStatusTriggers.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="oauth2"></a>
### oauth2

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://lusid.okta.com/oauth2/default/v1/authorize
- **Scopes**: N/A


## Author

info@finbourne.com


