# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
from ..request.http_method import HttpMethod
import pydantic
from ..configs.injection_location import InjectionLocation
from ..request.event_type import EventType
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EngineConfig_InjectionEngineConfig(UniversalBaseModel):
    type: typing.Literal["InjectionEngineConfig"] = "InjectionEngineConfig"
    targets: typing.List[str]
    method: HttpMethod
    paths: typing.List[str]
    baseline_payload: typing.Optional[typing.Dict[str, str]] = pydantic.Field(alias="baselinePayload", default=None)
    injected_payloads: typing.List[typing.Dict[str, str]] = pydantic.Field(alias="injectedPayloads")
    injection_location: InjectionLocation = pydantic.Field(alias="injectionLocation")
    event_type: EventType = pydantic.Field(alias="eventType")
    timeout: int
    retries: int
    sleep: int

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class EngineConfig_HeaderMisconfigurationEngineConfig(UniversalBaseModel):
    type: typing.Literal["HeaderMisconfigurationEngineConfig"] = "HeaderMisconfigurationEngineConfig"
    targets: typing.List[str]
    method: HttpMethod
    payloads: typing.List[typing.List[typing.Dict[str, str]]]
    event_type: EventType = pydantic.Field(alias="eventType")
    timeout: int
    retries: int
    sleep: int

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class EngineConfig_PathTraversalEngineConfig(UniversalBaseModel):
    type: typing.Literal["PathTraversalEngineConfig"] = "PathTraversalEngineConfig"
    targets: typing.List[str]
    paths: typing.Optional[typing.List[str]] = None
    path_files: typing.Optional[typing.List[str]] = pydantic.Field(alias="pathFiles", default=None)
    query_param: typing.Optional[str] = pydantic.Field(alias="queryParam", default=None)
    response_codes: str = pydantic.Field(alias="responseCodes")
    ignore_base_content: bool = pydantic.Field(alias="ignoreBaseContent")
    timeout: int
    retries: int
    sleep: int
    successful_only: bool = pydantic.Field(alias="successfulOnly")
    threshold: typing.Optional[float] = None
    max_run_time: typing.Optional[int] = pydantic.Field(alias="maxRunTime", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


EngineConfig = typing.Union[
    EngineConfig_InjectionEngineConfig,
    EngineConfig_HeaderMisconfigurationEngineConfig,
    EngineConfig_PathTraversalEngineConfig,
]
