from twilio.base import values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.voice.v1.dialing_permissions.country.highrisk_special_prefix import HighriskSpecialPrefixList as HighriskSpecialPrefixList
from typing import Any, Optional

class CountryList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, iso_code: Any = ..., continent: Any = ..., country_code: Any = ..., low_risk_numbers_enabled: Any = ..., high_risk_special_numbers_enabled: Any = ..., high_risk_tollfraud_numbers_enabled: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, iso_code: Any = ..., continent: Any = ..., country_code: Any = ..., low_risk_numbers_enabled: Any = ..., high_risk_special_numbers_enabled: Any = ..., high_risk_tollfraud_numbers_enabled: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, iso_code: Any = ..., continent: Any = ..., country_code: Any = ..., low_risk_numbers_enabled: Any = ..., high_risk_special_numbers_enabled: Any = ..., high_risk_tollfraud_numbers_enabled: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, iso_code: Any): ...
    def __call__(self, iso_code: Any): ...

class CountryPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class CountryContext(InstanceContext):
    def __init__(self, version: Any, iso_code: Any) -> None: ...
    def fetch(self): ...
    @property
    def highrisk_special_prefixes(self): ...

class CountryInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, iso_code: Optional[Any] = ...) -> None: ...
    @property
    def iso_code(self): ...
    @property
    def name(self): ...
    @property
    def continent(self): ...
    @property
    def country_codes(self): ...
    @property
    def low_risk_numbers_enabled(self): ...
    @property
    def high_risk_special_numbers_enabled(self): ...
    @property
    def high_risk_tollfraud_numbers_enabled(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    @property
    def highrisk_special_prefixes(self): ...
