from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class RecordingList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, status: Any = ..., source_sid: Any = ..., grouping_sid: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., media_type: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, status: Any = ..., source_sid: Any = ..., grouping_sid: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., media_type: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, status: Any = ..., source_sid: Any = ..., grouping_sid: Any = ..., date_created_after: Any = ..., date_created_before: Any = ..., media_type: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class RecordingPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class RecordingContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...

class RecordingInstance(InstanceResource):
    class Status:
        PROCESSING: str = ...
        COMPLETED: str = ...
        DELETED: str = ...
        FAILED: str = ...
    class Type:
        AUDIO: str = ...
        VIDEO: str = ...
        DATA: str = ...
    class Format:
        MKA: str = ...
        MKV: str = ...
    class Codec:
        VP8: str = ...
        H264: str = ...
        OPUS: str = ...
        PCMU: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def status(self): ...
    @property
    def date_created(self): ...
    @property
    def sid(self): ...
    @property
    def source_sid(self): ...
    @property
    def size(self): ...
    @property
    def url(self): ...
    @property
    def type(self): ...
    @property
    def duration(self): ...
    @property
    def container_format(self): ...
    @property
    def codec(self): ...
    @property
    def grouping_sids(self): ...
    @property
    def track_name(self): ...
    @property
    def offset(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self): ...
