from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class MessagingConfigurationList(ListResource):
    def __init__(self, version: Any, service_sid: Any) -> None: ...
    def create(self, country: Any, messaging_service_sid: Any): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, country: Any): ...
    def __call__(self, country: Any): ...

class MessagingConfigurationPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class MessagingConfigurationContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, country: Any) -> None: ...
    def update(self, messaging_service_sid: Any): ...
    def fetch(self): ...
    def delete(self): ...

class MessagingConfigurationInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, service_sid: Any, country: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def country(self): ...
    @property
    def messaging_service_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    def update(self, messaging_service_sid: Any): ...
    def fetch(self): ...
    def delete(self): ...
