from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.verify.v2.service.entity.challenge import ChallengeList as ChallengeList
from twilio.rest.verify.v2.service.entity.factor import FactorList as FactorList
from typing import Any, Optional

class EntityList(ListResource):
    def __init__(self, version: Any, service_sid: Any) -> None: ...
    def create(self, identity: Any, twilio_sandbox_mode: Any = ...): ...
    def stream(self, twilio_sandbox_mode: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, twilio_sandbox_mode: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, twilio_sandbox_mode: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, identity: Any): ...
    def __call__(self, identity: Any): ...

class EntityPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class EntityContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, identity: Any) -> None: ...
    def delete(self, twilio_sandbox_mode: Any = ...): ...
    def fetch(self, twilio_sandbox_mode: Any = ...): ...
    @property
    def factors(self): ...
    @property
    def challenges(self): ...

class EntityInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, service_sid: Any, identity: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def identity(self): ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def delete(self, twilio_sandbox_mode: Any = ...): ...
    def fetch(self, twilio_sandbox_mode: Any = ...): ...
    @property
    def factors(self): ...
    @property
    def challenges(self): ...
