from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.verify.v2.service.access_token import AccessTokenList as AccessTokenList
from twilio.rest.verify.v2.service.entity import EntityList as EntityList
from twilio.rest.verify.v2.service.messaging_configuration import MessagingConfigurationList as MessagingConfigurationList
from twilio.rest.verify.v2.service.rate_limit import RateLimitList as RateLimitList
from twilio.rest.verify.v2.service.verification import VerificationList as VerificationList
from twilio.rest.verify.v2.service.verification_check import VerificationCheckList as VerificationCheckList
from twilio.rest.verify.v2.service.webhook import WebhookList as WebhookList
from typing import Any, Optional

class ServiceList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any, code_length: Any = ..., lookup_enabled: Any = ..., skip_sms_to_landlines: Any = ..., dtmf_input_required: Any = ..., tts_name: Any = ..., psd2_enabled: Any = ..., do_not_share_warning_enabled: Any = ..., custom_code_enabled: Any = ..., push_include_date: Any = ..., push_apn_credential_sid: Any = ..., push_fcm_credential_sid: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ServicePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ServiceContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, friendly_name: Any = ..., code_length: Any = ..., lookup_enabled: Any = ..., skip_sms_to_landlines: Any = ..., dtmf_input_required: Any = ..., tts_name: Any = ..., psd2_enabled: Any = ..., do_not_share_warning_enabled: Any = ..., custom_code_enabled: Any = ..., push_include_date: Any = ..., push_apn_credential_sid: Any = ..., push_fcm_credential_sid: Any = ...): ...
    @property
    def verifications(self): ...
    @property
    def verification_checks(self): ...
    @property
    def rate_limits(self): ...
    @property
    def messaging_configurations(self): ...
    @property
    def entities(self): ...
    @property
    def webhooks(self): ...
    @property
    def access_tokens(self): ...

class ServiceInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def code_length(self): ...
    @property
    def lookup_enabled(self): ...
    @property
    def psd2_enabled(self): ...
    @property
    def skip_sms_to_landlines(self): ...
    @property
    def dtmf_input_required(self): ...
    @property
    def tts_name(self): ...
    @property
    def do_not_share_warning_enabled(self): ...
    @property
    def custom_code_enabled(self): ...
    @property
    def push(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, friendly_name: Any = ..., code_length: Any = ..., lookup_enabled: Any = ..., skip_sms_to_landlines: Any = ..., dtmf_input_required: Any = ..., tts_name: Any = ..., psd2_enabled: Any = ..., do_not_share_warning_enabled: Any = ..., custom_code_enabled: Any = ..., push_include_date: Any = ..., push_apn_credential_sid: Any = ..., push_fcm_credential_sid: Any = ...): ...
    @property
    def verifications(self): ...
    @property
    def verification_checks(self): ...
    @property
    def rate_limits(self): ...
    @property
    def messaging_configurations(self): ...
    @property
    def entities(self): ...
    @property
    def webhooks(self): ...
    @property
    def access_tokens(self): ...
