from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.taskrouter.v1.workspace.task_queue.task_queue_cumulative_statistics import TaskQueueCumulativeStatisticsList as TaskQueueCumulativeStatisticsList
from twilio.rest.taskrouter.v1.workspace.task_queue.task_queue_real_time_statistics import TaskQueueRealTimeStatisticsList as TaskQueueRealTimeStatisticsList
from twilio.rest.taskrouter.v1.workspace.task_queue.task_queue_statistics import TaskQueueStatisticsList as TaskQueueStatisticsList
from twilio.rest.taskrouter.v1.workspace.task_queue.task_queues_statistics import TaskQueuesStatisticsList as TaskQueuesStatisticsList
from typing import Any, Optional

class TaskQueueList(ListResource):
    def __init__(self, version: Any, workspace_sid: Any) -> None: ...
    def stream(self, friendly_name: Any = ..., evaluate_worker_attributes: Any = ..., worker_sid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, friendly_name: Any = ..., evaluate_worker_attributes: Any = ..., worker_sid: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, friendly_name: Any = ..., evaluate_worker_attributes: Any = ..., worker_sid: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, friendly_name: Any, target_workers: Any = ..., max_reserved_workers: Any = ..., task_order: Any = ..., reservation_activity_sid: Any = ..., assignment_activity_sid: Any = ...): ...
    @property
    def statistics(self): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class TaskQueuePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class TaskQueueContext(InstanceContext):
    def __init__(self, version: Any, workspace_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., target_workers: Any = ..., reservation_activity_sid: Any = ..., assignment_activity_sid: Any = ..., max_reserved_workers: Any = ..., task_order: Any = ...): ...
    def delete(self): ...
    @property
    def statistics(self): ...
    @property
    def real_time_statistics(self): ...
    @property
    def cumulative_statistics(self): ...

class TaskQueueInstance(InstanceResource):
    class TaskOrder:
        FIFO: str = ...
        LIFO: str = ...
    def __init__(self, version: Any, payload: Any, workspace_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def assignment_activity_sid(self): ...
    @property
    def assignment_activity_name(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def friendly_name(self): ...
    @property
    def max_reserved_workers(self): ...
    @property
    def reservation_activity_sid(self): ...
    @property
    def reservation_activity_name(self): ...
    @property
    def sid(self): ...
    @property
    def target_workers(self): ...
    @property
    def task_order(self): ...
    @property
    def url(self): ...
    @property
    def workspace_sid(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def update(self, friendly_name: Any = ..., target_workers: Any = ..., reservation_activity_sid: Any = ..., assignment_activity_sid: Any = ..., max_reserved_workers: Any = ..., task_order: Any = ...): ...
    def delete(self): ...
    @property
    def statistics(self): ...
    @property
    def real_time_statistics(self): ...
    @property
    def cumulative_statistics(self): ...
