from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class ReservationList(ListResource):
    def __init__(self, version: Any, workspace_sid: Any, task_sid: Any) -> None: ...
    def stream(self, reservation_status: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, reservation_status: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, reservation_status: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ReservationPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ReservationContext(InstanceContext):
    def __init__(self, version: Any, workspace_sid: Any, task_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, reservation_status: Any = ..., worker_activity_sid: Any = ..., instruction: Any = ..., dequeue_post_work_activity_sid: Any = ..., dequeue_from: Any = ..., dequeue_record: Any = ..., dequeue_timeout: Any = ..., dequeue_to: Any = ..., dequeue_status_callback_url: Any = ..., call_from: Any = ..., call_record: Any = ..., call_timeout: Any = ..., call_to: Any = ..., call_url: Any = ..., call_status_callback_url: Any = ..., call_accept: Any = ..., redirect_call_sid: Any = ..., redirect_accept: Any = ..., redirect_url: Any = ..., to: Any = ..., from_: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., status_callback_event: Any = ..., timeout: Any = ..., record: Any = ..., muted: Any = ..., beep: Any = ..., start_conference_on_enter: Any = ..., end_conference_on_exit: Any = ..., wait_url: Any = ..., wait_method: Any = ..., early_media: Any = ..., max_participants: Any = ..., conference_status_callback: Any = ..., conference_status_callback_method: Any = ..., conference_status_callback_event: Any = ..., conference_record: Any = ..., conference_trim: Any = ..., recording_channels: Any = ..., recording_status_callback: Any = ..., recording_status_callback_method: Any = ..., conference_recording_status_callback: Any = ..., conference_recording_status_callback_method: Any = ..., region: Any = ..., sip_auth_username: Any = ..., sip_auth_password: Any = ..., dequeue_status_callback_event: Any = ..., post_work_activity_sid: Any = ..., supervisor_mode: Any = ..., supervisor: Any = ..., end_conference_on_customer_exit: Any = ..., beep_on_customer_entrance: Any = ...): ...

class ReservationInstance(InstanceResource):
    class Status:
        PENDING: str = ...
        ACCEPTED: str = ...
        REJECTED: str = ...
        TIMEOUT: str = ...
        CANCELED: str = ...
        RESCINDED: str = ...
        WRAPPING: str = ...
        COMPLETED: str = ...
    class CallStatus:
        INITIATED: str = ...
        RINGING: str = ...
        ANSWERED: str = ...
        COMPLETED: str = ...
    class ConferenceEvent:
        START: str = ...
        END: str = ...
        JOIN: str = ...
        LEAVE: str = ...
        MUTE: str = ...
        HOLD: str = ...
        SPEAKER: str = ...
    class SupervisorMode:
        MONITOR: str = ...
        WHISPER: str = ...
        BARGE: str = ...
    def __init__(self, version: Any, payload: Any, workspace_sid: Any, task_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def reservation_status(self): ...
    @property
    def sid(self): ...
    @property
    def task_sid(self): ...
    @property
    def worker_name(self): ...
    @property
    def worker_sid(self): ...
    @property
    def workspace_sid(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def update(self, reservation_status: Any = ..., worker_activity_sid: Any = ..., instruction: Any = ..., dequeue_post_work_activity_sid: Any = ..., dequeue_from: Any = ..., dequeue_record: Any = ..., dequeue_timeout: Any = ..., dequeue_to: Any = ..., dequeue_status_callback_url: Any = ..., call_from: Any = ..., call_record: Any = ..., call_timeout: Any = ..., call_to: Any = ..., call_url: Any = ..., call_status_callback_url: Any = ..., call_accept: Any = ..., redirect_call_sid: Any = ..., redirect_accept: Any = ..., redirect_url: Any = ..., to: Any = ..., from_: Any = ..., status_callback: Any = ..., status_callback_method: Any = ..., status_callback_event: Any = ..., timeout: Any = ..., record: Any = ..., muted: Any = ..., beep: Any = ..., start_conference_on_enter: Any = ..., end_conference_on_exit: Any = ..., wait_url: Any = ..., wait_method: Any = ..., early_media: Any = ..., max_participants: Any = ..., conference_status_callback: Any = ..., conference_status_callback_method: Any = ..., conference_status_callback_event: Any = ..., conference_record: Any = ..., conference_trim: Any = ..., recording_channels: Any = ..., recording_status_callback: Any = ..., recording_status_callback_method: Any = ..., conference_recording_status_callback: Any = ..., conference_recording_status_callback_method: Any = ..., region: Any = ..., sip_auth_username: Any = ..., sip_auth_password: Any = ..., dequeue_status_callback_event: Any = ..., post_work_activity_sid: Any = ..., supervisor_mode: Any = ..., supervisor: Any = ..., end_conference_on_customer_exit: Any = ..., beep_on_customer_entrance: Any = ...): ...
