from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.serverless.v1.service.asset import AssetList as AssetList
from twilio.rest.serverless.v1.service.build import BuildList as BuildList
from twilio.rest.serverless.v1.service.environment import EnvironmentList as EnvironmentList
from twilio.rest.serverless.v1.service.function import FunctionList as FunctionList
from typing import Any, Optional

class ServiceList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, unique_name: Any, friendly_name: Any, include_credentials: Any = ..., ui_editable: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ServicePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ServiceContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, include_credentials: Any = ..., friendly_name: Any = ..., ui_editable: Any = ...): ...
    @property
    def environments(self): ...
    @property
    def functions(self): ...
    @property
    def assets(self): ...
    @property
    def builds(self): ...

class ServiceInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def unique_name(self): ...
    @property
    def include_credentials(self): ...
    @property
    def ui_editable(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, include_credentials: Any = ..., friendly_name: Any = ..., ui_editable: Any = ...): ...
    @property
    def environments(self): ...
    @property
    def functions(self): ...
    @property
    def assets(self): ...
    @property
    def builds(self): ...
