from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.proxy.v1.service.session.interaction import InteractionList as InteractionList
from twilio.rest.proxy.v1.service.session.participant import ParticipantList as ParticipantList
from typing import Any, Optional

class SessionList(ListResource):
    def __init__(self, version: Any, service_sid: Any) -> None: ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, unique_name: Any = ..., date_expiry: Any = ..., ttl: Any = ..., mode: Any = ..., status: Any = ..., participants: Any = ..., fail_on_participant_conflict: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class SessionPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class SessionContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, date_expiry: Any = ..., ttl: Any = ..., status: Any = ..., fail_on_participant_conflict: Any = ...): ...
    @property
    def interactions(self): ...
    @property
    def participants(self): ...

class SessionInstance(InstanceResource):
    class Status:
        OPEN: str = ...
        IN_PROGRESS: str = ...
        CLOSED: str = ...
        FAILED: str = ...
        UNKNOWN: str = ...
    class Mode:
        MESSAGE_ONLY: str = ...
        VOICE_ONLY: str = ...
        VOICE_AND_MESSAGE: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def date_started(self): ...
    @property
    def date_ended(self): ...
    @property
    def date_last_interaction(self): ...
    @property
    def date_expiry(self): ...
    @property
    def unique_name(self): ...
    @property
    def status(self): ...
    @property
    def closed_reason(self): ...
    @property
    def ttl(self): ...
    @property
    def mode(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, date_expiry: Any = ..., ttl: Any = ..., status: Any = ..., fail_on_participant_conflict: Any = ...): ...
    @property
    def interactions(self): ...
    @property
    def participants(self): ...
