from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.preview.wireless.sim.usage import UsageList as UsageList
from typing import Any, Optional

class SimList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, status: Any = ..., iccid: Any = ..., rate_plan: Any = ..., e_id: Any = ..., sim_registration_code: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, status: Any = ..., iccid: Any = ..., rate_plan: Any = ..., e_id: Any = ..., sim_registration_code: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, status: Any = ..., iccid: Any = ..., rate_plan: Any = ..., e_id: Any = ..., sim_registration_code: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class SimPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class SimContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def update(self, unique_name: Any = ..., callback_method: Any = ..., callback_url: Any = ..., friendly_name: Any = ..., rate_plan: Any = ..., status: Any = ..., commands_callback_method: Any = ..., commands_callback_url: Any = ..., sms_fallback_method: Any = ..., sms_fallback_url: Any = ..., sms_method: Any = ..., sms_url: Any = ..., voice_fallback_method: Any = ..., voice_fallback_url: Any = ..., voice_method: Any = ..., voice_url: Any = ...): ...
    @property
    def usage(self): ...

class SimInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def unique_name(self): ...
    @property
    def account_sid(self): ...
    @property
    def rate_plan_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def iccid(self): ...
    @property
    def e_id(self): ...
    @property
    def status(self): ...
    @property
    def commands_callback_url(self): ...
    @property
    def commands_callback_method(self): ...
    @property
    def sms_fallback_method(self): ...
    @property
    def sms_fallback_url(self): ...
    @property
    def sms_method(self): ...
    @property
    def sms_url(self): ...
    @property
    def voice_fallback_method(self): ...
    @property
    def voice_fallback_url(self): ...
    @property
    def voice_method(self): ...
    @property
    def voice_url(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def update(self, unique_name: Any = ..., callback_method: Any = ..., callback_url: Any = ..., friendly_name: Any = ..., rate_plan: Any = ..., status: Any = ..., commands_callback_method: Any = ..., commands_callback_url: Any = ..., sms_fallback_method: Any = ..., sms_fallback_url: Any = ..., sms_method: Any = ..., sms_url: Any = ..., voice_fallback_method: Any = ..., voice_fallback_url: Any = ..., voice_method: Any = ..., voice_url: Any = ...): ...
    @property
    def usage(self): ...
