from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class HostedNumberOrderList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, status: Any = ..., phone_number: Any = ..., incoming_phone_number_sid: Any = ..., friendly_name: Any = ..., unique_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, status: Any = ..., phone_number: Any = ..., incoming_phone_number_sid: Any = ..., friendly_name: Any = ..., unique_name: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, status: Any = ..., phone_number: Any = ..., incoming_phone_number_sid: Any = ..., friendly_name: Any = ..., unique_name: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def create(self, phone_number: Any, sms_capability: Any, account_sid: Any = ..., friendly_name: Any = ..., unique_name: Any = ..., cc_emails: Any = ..., sms_url: Any = ..., sms_method: Any = ..., sms_fallback_url: Any = ..., sms_fallback_method: Any = ..., status_callback_url: Any = ..., status_callback_method: Any = ..., sms_application_sid: Any = ..., address_sid: Any = ..., email: Any = ..., verification_type: Any = ..., verification_document_sid: Any = ...): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class HostedNumberOrderPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class HostedNumberOrderContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, friendly_name: Any = ..., unique_name: Any = ..., email: Any = ..., cc_emails: Any = ..., status: Any = ..., verification_code: Any = ..., verification_type: Any = ..., verification_document_sid: Any = ..., extension: Any = ..., call_delay: Any = ...): ...

class HostedNumberOrderInstance(InstanceResource):
    class Status:
        RECEIVED: str = ...
        PENDING_VERIFICATION: str = ...
        VERIFIED: str = ...
        PENDING_LOA: str = ...
        CARRIER_PROCESSING: str = ...
        TESTING: str = ...
        COMPLETED: str = ...
        FAILED: str = ...
        ACTION_REQUIRED: str = ...
    class VerificationType:
        PHONE_CALL: str = ...
        PHONE_BILL: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def incoming_phone_number_sid(self): ...
    @property
    def address_sid(self): ...
    @property
    def signing_document_sid(self): ...
    @property
    def phone_number(self): ...
    @property
    def capabilities(self): ...
    @property
    def friendly_name(self): ...
    @property
    def unique_name(self): ...
    @property
    def status(self): ...
    @property
    def failure_reason(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def verification_attempts(self): ...
    @property
    def email(self): ...
    @property
    def cc_emails(self): ...
    @property
    def url(self): ...
    @property
    def verification_type(self): ...
    @property
    def verification_document_sid(self): ...
    @property
    def extension(self): ...
    @property
    def call_delay(self): ...
    @property
    def verification_code(self): ...
    @property
    def verification_call_sids(self): ...
    def fetch(self): ...
    def delete(self): ...
    def update(self, friendly_name: Any = ..., unique_name: Any = ..., email: Any = ..., cc_emails: Any = ..., status: Any = ..., verification_code: Any = ..., verification_type: Any = ..., verification_document_sid: Any = ..., extension: Any = ..., call_delay: Any = ...): ...
