from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class EventList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def stream(self, actor_sid: Any = ..., event_type: Any = ..., resource_sid: Any = ..., source_ip_address: Any = ..., start_date: Any = ..., end_date: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, actor_sid: Any = ..., event_type: Any = ..., resource_sid: Any = ..., source_ip_address: Any = ..., start_date: Any = ..., end_date: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, actor_sid: Any = ..., event_type: Any = ..., resource_sid: Any = ..., source_ip_address: Any = ..., start_date: Any = ..., end_date: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class EventPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class EventContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def fetch(self): ...

class EventInstance(InstanceResource):
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def actor_sid(self): ...
    @property
    def actor_type(self): ...
    @property
    def description(self): ...
    @property
    def event_data(self): ...
    @property
    def event_date(self): ...
    @property
    def event_type(self): ...
    @property
    def resource_sid(self): ...
    @property
    def resource_type(self): ...
    @property
    def sid(self): ...
    @property
    def source(self): ...
    @property
    def source_ip_address(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
