from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.messaging.v1.service.alpha_sender import AlphaSenderList as AlphaSenderList
from twilio.rest.messaging.v1.service.phone_number import PhoneNumberList as PhoneNumberList
from twilio.rest.messaging.v1.service.short_code import ShortCodeList as ShortCodeList
from typing import Any, Optional

class ServiceList(ListResource):
    def __init__(self, version: Any) -> None: ...
    def create(self, friendly_name: Any, inbound_request_url: Any = ..., inbound_method: Any = ..., fallback_url: Any = ..., fallback_method: Any = ..., status_callback: Any = ..., sticky_sender: Any = ..., mms_converter: Any = ..., smart_encoding: Any = ..., scan_message_content: Any = ..., fallback_to_long_code: Any = ..., area_code_geomatch: Any = ..., validity_period: Any = ..., synchronous_validation: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ServicePage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ServiceContext(InstanceContext):
    def __init__(self, version: Any, sid: Any) -> None: ...
    def update(self, friendly_name: Any = ..., inbound_request_url: Any = ..., inbound_method: Any = ..., fallback_url: Any = ..., fallback_method: Any = ..., status_callback: Any = ..., sticky_sender: Any = ..., mms_converter: Any = ..., smart_encoding: Any = ..., scan_message_content: Any = ..., fallback_to_long_code: Any = ..., area_code_geomatch: Any = ..., validity_period: Any = ..., synchronous_validation: Any = ...): ...
    def fetch(self): ...
    def delete(self): ...
    @property
    def phone_numbers(self): ...
    @property
    def short_codes(self): ...
    @property
    def alpha_senders(self): ...

class ServiceInstance(InstanceResource):
    class ScanMessageContent:
        INHERIT: str = ...
        ENABLE: str = ...
        DISABLE: str = ...
    def __init__(self, version: Any, payload: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def inbound_request_url(self): ...
    @property
    def inbound_method(self): ...
    @property
    def fallback_url(self): ...
    @property
    def fallback_method(self): ...
    @property
    def status_callback(self): ...
    @property
    def sticky_sender(self): ...
    @property
    def mms_converter(self): ...
    @property
    def smart_encoding(self): ...
    @property
    def scan_message_content(self): ...
    @property
    def fallback_to_long_code(self): ...
    @property
    def area_code_geomatch(self): ...
    @property
    def synchronous_validation(self): ...
    @property
    def validity_period(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def update(self, friendly_name: Any = ..., inbound_request_url: Any = ..., inbound_method: Any = ..., fallback_url: Any = ..., fallback_method: Any = ..., status_callback: Any = ..., sticky_sender: Any = ..., mms_converter: Any = ..., smart_encoding: Any = ..., scan_message_content: Any = ..., fallback_to_long_code: Any = ..., area_code_geomatch: Any = ..., validity_period: Any = ..., synchronous_validation: Any = ...): ...
    def fetch(self): ...
    def delete(self): ...
    @property
    def phone_numbers(self): ...
    @property
    def short_codes(self): ...
    @property
    def alpha_senders(self): ...
