from twilio.base import deserialize as deserialize, serialize as serialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from twilio.rest.ip_messaging.v2.service.channel.invite import InviteList as InviteList
from twilio.rest.ip_messaging.v2.service.channel.member import MemberList as MemberList
from twilio.rest.ip_messaging.v2.service.channel.message import MessageList as MessageList
from twilio.rest.ip_messaging.v2.service.channel.webhook import WebhookList as WebhookList
from typing import Any, Optional

class ChannelList(ListResource):
    def __init__(self, version: Any, service_sid: Any) -> None: ...
    def create(self, friendly_name: Any = ..., unique_name: Any = ..., attributes: Any = ..., type: Any = ..., date_created: Any = ..., date_updated: Any = ..., created_by: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def stream(self, type: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, type: Any = ..., limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, type: Any = ..., page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class ChannelPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class ChannelContext(InstanceContext):
    def __init__(self, version: Any, service_sid: Any, sid: Any) -> None: ...
    def fetch(self): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def update(self, friendly_name: Any = ..., unique_name: Any = ..., attributes: Any = ..., date_created: Any = ..., date_updated: Any = ..., created_by: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    @property
    def members(self): ...
    @property
    def messages(self): ...
    @property
    def invites(self): ...
    @property
    def webhooks(self): ...

class ChannelInstance(InstanceResource):
    class ChannelType:
        PUBLIC: str = ...
        PRIVATE: str = ...
    class WebhookEnabledType:
        TRUE: str = ...
        FALSE: str = ...
    def __init__(self, version: Any, payload: Any, service_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def service_sid(self): ...
    @property
    def friendly_name(self): ...
    @property
    def unique_name(self): ...
    @property
    def attributes(self): ...
    @property
    def type(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def created_by(self): ...
    @property
    def members_count(self): ...
    @property
    def messages_count(self): ...
    @property
    def url(self): ...
    @property
    def links(self): ...
    def fetch(self): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def update(self, friendly_name: Any = ..., unique_name: Any = ..., attributes: Any = ..., date_created: Any = ..., date_updated: Any = ..., created_by: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    @property
    def members(self): ...
    @property
    def messages(self): ...
    @property
    def invites(self): ...
    @property
    def webhooks(self): ...
