from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any

class CallSummaryList(ListResource):
    def __init__(self, version: Any, call_sid: Any) -> None: ...
    def get(self): ...
    def __call__(self): ...

class CallSummaryPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class CallSummaryContext(InstanceContext):
    def __init__(self, version: Any, call_sid: Any) -> None: ...
    def fetch(self, processing_state: Any = ...): ...

class CallSummaryInstance(InstanceResource):
    class CallType:
        CARRIER: str = ...
        SIP: str = ...
        TRUNKING: str = ...
        CLIENT: str = ...
    class CallState:
        RINGING: str = ...
        COMPLETED: str = ...
        BUSY: str = ...
        FAIL: str = ...
        NOANSWER: str = ...
        CANCELED: str = ...
        ANSWERED: str = ...
        UNDIALED: str = ...
    class ProcessingState:
        COMPLETE: str = ...
        PARTIAL: str = ...
    def __init__(self, version: Any, payload: Any, call_sid: Any) -> None: ...
    @property
    def account_sid(self): ...
    @property
    def call_sid(self): ...
    @property
    def call_type(self): ...
    @property
    def call_state(self): ...
    @property
    def processing_state(self): ...
    @property
    def start_time(self): ...
    @property
    def end_time(self): ...
    @property
    def duration(self): ...
    @property
    def connect_duration(self): ...
    @property
    def from_(self): ...
    @property
    def to(self): ...
    @property
    def carrier_edge(self): ...
    @property
    def client_edge(self): ...
    @property
    def sdk_edge(self): ...
    @property
    def sip_edge(self): ...
    @property
    def tags(self): ...
    @property
    def url(self): ...
    @property
    def attributes(self): ...
    @property
    def properties(self): ...
    @property
    def trust(self): ...
    def fetch(self, processing_state: Any = ...): ...
