from twilio.base import deserialize as deserialize, values as values
from twilio.base.instance_context import InstanceContext as InstanceContext
from twilio.base.instance_resource import InstanceResource as InstanceResource
from twilio.base.list_resource import ListResource as ListResource
from twilio.base.page import Page as Page
from typing import Any, Optional

class UserList(ListResource):
    def __init__(self, version: Any, chat_service_sid: Any) -> None: ...
    def create(self, identity: Any, friendly_name: Any = ..., attributes: Any = ..., role_sid: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def stream(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def list(self, limit: Optional[Any] = ..., page_size: Optional[Any] = ...): ...
    def page(self, page_token: Any = ..., page_number: Any = ..., page_size: Any = ...): ...
    def get_page(self, target_url: Any): ...
    def get(self, sid: Any): ...
    def __call__(self, sid: Any): ...

class UserPage(Page):
    def __init__(self, version: Any, response: Any, solution: Any) -> None: ...
    def get_instance(self, payload: Any): ...

class UserContext(InstanceContext):
    def __init__(self, version: Any, chat_service_sid: Any, sid: Any) -> None: ...
    def update(self, friendly_name: Any = ..., attributes: Any = ..., role_sid: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def fetch(self): ...

class UserInstance(InstanceResource):
    class WebhookEnabledType:
        TRUE: str = ...
        FALSE: str = ...
    def __init__(self, version: Any, payload: Any, chat_service_sid: Any, sid: Optional[Any] = ...) -> None: ...
    @property
    def sid(self): ...
    @property
    def account_sid(self): ...
    @property
    def chat_service_sid(self): ...
    @property
    def role_sid(self): ...
    @property
    def identity(self): ...
    @property
    def friendly_name(self): ...
    @property
    def attributes(self): ...
    @property
    def is_online(self): ...
    @property
    def date_created(self): ...
    @property
    def date_updated(self): ...
    @property
    def url(self): ...
    def update(self, friendly_name: Any = ..., attributes: Any = ..., role_sid: Any = ..., x_twilio_webhook_enabled: Any = ...): ...
    def delete(self, x_twilio_webhook_enabled: Any = ...): ...
    def fetch(self): ...
